; Datei zum Includen fr das zyklische Wechseln der Baudrate und COM-Anschlusses


; Funktionen in dieser INC-Datei:
; -------------------------------
;
; Baudrate:
;	CnB.Baudrate_GET_Str
;	CnB.Baudrate_GET_Str_next
;	CnB.Baudrate_SET_next
;	CnB.Baudrate_SET_default
;	CnB.Baudrate_SET
;	CnB.Baudrate_SET_1200
;	CnB.Baudrate_SET_2400
;	CnB.Baudrate_SET_4800
;	CnB.Baudrate_SET_9600
;	CnB.Baudrate_SET_19200
;	CnB.Baudrate_SET_38400
;	CnB.Baudrate_SET_57600
;	CnB.Baudrate_SET_115200
;	CnB.Baudrate_SET_250000
;
; COM-Port:
;	CnB.COM_Port_GET_Str
;	CnB.COM_Port_GET_Str_next
;	CnB.COM_Port_SET_next
;	CnB.COM_Port_SET_next_default_Baud
;	CnB.COM_Port_SET
;	CnB.COM_Port_SET_COM0
;	CnB.COM_Port_SET_COM1
;	CnB.COM_Port_SET_COM2
;
; Gemischt:
;	CnB.COM_Port_Baudrate_SET_all_to_default
;	CnB.COM_Port_Baudrate_SET_others_to_default
;



; Definiton der String-Constanten
CONST CnB.Str_BR_1200   = '1200'
CONST CnB.Str_BR_2400   = '2400'
CONST CnB.Str_BR_4800   = '4800'
CONST CnB.Str_BR_9600   = '9600'
CONST CnB.Str_BR_19200  = '19200'
CONST CnB.Str_BR_38400  = '38400'
CONST CnB.Str_BR_57600  = '57600'
CONST CnB.Str_BR_115200 = '115200'
CONST CnB.Str_BR_250000 = '250000'

CONST CnB.Str_Prt_COM0   = 'COM0'
CONST CnB.Str_Prt_COM1   = 'COM1'
CONST CnB.Str_Prt_COM2   = 'COM2'


; String Variablen fr Rckgabewerte:
STRING[20]	CnB.Baudrate.$	= ''
STRING[12]	CnB.COM_Port.$	= ''


; Integer Variablen fr Rckgabewerte:
INTEGER	CnB.BAUDRATE.I = Baud_38400
INTEGER	CnB.COM_Port.I = COM2
INTEGER	CnB.COM_Port_save.I
INTEGER	CnB.BAUDRATE_save.I


; Baudrate _________________________________________________________

; Baudrate GET -----------------------------------------------------

SUB CnB.Baudrate_GET_Str
	IF     CnB.BAUDRATE.I == Baud_1200 THEN
		CnB.Baudrate.$ := CnB.Str_BR_1200
	ELSIF  CnB.BAUDRATE.I == Baud_2400 THEN
		CnB.Baudrate.$ := CnB.Str_BR_2400
	ELSIF  CnB.BAUDRATE.I == Baud_4800 THEN
		CnB.Baudrate.$ := CnB.Str_BR_4800
	ELSIF  CnB.BAUDRATE.I == Baud_9600 THEN
		CnB.Baudrate.$ := CnB.Str_BR_9600
	ELSIF  CnB.BAUDRATE.I == Baud_19200 THEN
		CnB.Baudrate.$ := CnB.Str_BR_19200
	ELSIF  CnB.BAUDRATE.I == Baud_38400 THEN
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ELSIF  CnB.BAUDRATE.I == Baud_57600 THEN
		CnB.Baudrate.$ := CnB.Str_BR_57600
	ELSIF  CnB.BAUDRATE.I == Baud_115200 THEN
		CnB.Baudrate.$ := CnB.Str_BR_115200
	ELSIF  CnB.BAUDRATE.I == Baud_250000 THEN
		CnB.Baudrate.$ := CnB.Str_BR_250000
	ENDIF
ENDSUB

SUB CnB.Baudrate_GET_Str_next
	IF     CnB.BAUDRATE.I == Baud_1200 THEN
		CnB.Baudrate.$ := CnB.Str_BR_2400
	ELSIF  CnB.BAUDRATE.I == Baud_2400 THEN
		CnB.Baudrate.$ := CnB.Str_BR_4800
	ELSIF  CnB.BAUDRATE.I == Baud_4800 THEN
		CnB.Baudrate.$ := CnB.Str_BR_9600
	ELSIF  CnB.BAUDRATE.I == Baud_9600 THEN
		CnB.Baudrate.$ := CnB.Str_BR_19200
	ELSIF  CnB.BAUDRATE.I == Baud_19200 THEN
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ELSIF  CnB.BAUDRATE.I == Baud_38400 THEN
		CnB.Baudrate.$ := CnB.Str_BR_57600
	ELSIF  CnB.BAUDRATE.I == Baud_57600 THEN
		CnB.Baudrate.$ := CnB.Str_BR_115200
	ELSIF  CnB.BAUDRATE.I == Baud_115200 THEN
		CnB.Baudrate.$ := CnB.Str_BR_250000
	ELSIF  CnB.BAUDRATE.I == Baud_250000 THEN
		CnB.Baudrate.$ := CnB.Str_BR_1200
	ENDIF
ENDSUB

; Baudrate SET -----------------------------------------------------

SUB CnB.Baudrate_SET_next
	IF     CnB.BAUDRATE.I == Baud_1200 THEN
		CnB.BAUDRATE.I := Baud_2400
		CnB.Baudrate.$ := CnB.Str_BR_2400
	ELSIF  CnB.BAUDRATE.I == Baud_2400 THEN
		CnB.BAUDRATE.I := Baud_4800
		CnB.Baudrate.$ := CnB.Str_BR_4800
	ELSIF  CnB.BAUDRATE.I == Baud_4800 THEN
		CnB.BAUDRATE.I := Baud_9600
		CnB.Baudrate.$ := CnB.Str_BR_9600
	ELSIF  CnB.BAUDRATE.I == Baud_9600 THEN
		CnB.BAUDRATE.I := Baud_19200
		CnB.Baudrate.$ := CnB.Str_BR_19200
	ELSIF  CnB.BAUDRATE.I == Baud_19200 THEN
		CnB.BAUDRATE.I := Baud_38400
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ELSIF  CnB.BAUDRATE.I == Baud_38400 THEN
		CnB.BAUDRATE.I := Baud_57600
		CnB.Baudrate.$ := CnB.Str_BR_57600
	ELSIF  CnB.BAUDRATE.I == Baud_57600 THEN
		CnB.BAUDRATE.I := Baud_115200
		CnB.Baudrate.$ := CnB.Str_BR_115200
	ELSIF  CnB.BAUDRATE.I == Baud_115200 THEN
		CnB.BAUDRATE.I := Baud_250000
		CnB.Baudrate.$ := CnB.Str_BR_250000
	ELSIF  CnB.BAUDRATE.I == Baud_250000 THEN
		CnB.BAUDRATE.I := Baud_1200
		CnB.Baudrate.$ := CnB.Str_BR_1200
	ENDIF 
	Serial.SetBaudrate( CnB.COM_Port.I, CnB.BAUDRATE.I )
ENDSUB


SUB CnB.Baudrate_SET_default
	; reset to default value
	IF    CnB.COM_Port.I == COM1 THEN
		CnB.BAUDRATE.I := Baud_38400
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ELSIF CnB.COM_Port.I == COM2 THEN
		CnB.BAUDRATE.I := Baud_38400
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ELSIF CnB.COM_Port.I == COM0 THEN
		CnB.BAUDRATE.I := Baud_250000
		CnB.Baudrate.$ := CnB.Str_BR_250000
	ENDIF
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB


SUB CnB.Baudrate_SET
	; Setzten der Baudrate wie in CnB.BAUDRATE.I am Port: CnB.COM_Port.I
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_1200
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_1200
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_2400
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_2400
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_4800
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_4800
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_9600
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_9600
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_19200
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_19200
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_38400
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_38400
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_57600
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_57600
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_115200
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_115200
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.Baudrate_SET_250000
	; Setzten der Baudrate am Port: CnB.COM_Port.I
	CnB.BAUDRATE.I := Baud_250000
	CallSubroutine( CnB.Baudrate_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB



; COM-Port _________________________________________________________

; COM-Port GET -----------------------------------------------------

SUB CnB.COM_Port_GET_Str
	IF    CnB.COM_Port.I == COM1 THEN
		CnB.COM_Port.$ := CnB.Str_Prt_COM1
	ELSIF CnB.COM_Port.I == COM2 THEN
		CnB.COM_Port.$ := CnB.Str_Prt_COM2
	ELSIF CnB.COM_Port.I == COM0 THEN
		CnB.COM_Port.$ := CnB.Str_Prt_COM0
	ENDIF
ENDSUB


SUB CnB.COM_Port_GET_Str_next
	IF    CnB.COM_Port.I == COM1 THEN
		CnB.COM_Port.$ := CnB.Str_Prt_COM2
	ELSIF CnB.COM_Port.I == COM2 THEN
		CnB.COM_Port.$ := CnB.Str_Prt_COM0
	ELSIF CnB.COM_Port.I == COM0 THEN
		CnB.COM_Port.$ := CnB.Str_Prt_COM1
	ENDIF
ENDSUB

; COM-Port SET -----------------------------------------------------

SUB CnB.COM_Port_SET_next
	IF    CnB.COM_Port.I == COM1 THEN
		CnB.COM_Port.I := COM2
		CnB.COM_Port.$ := CnB.Str_Prt_COM2
	ELSIF CnB.COM_Port.I == COM2 THEN
		CnB.COM_Port.I := COM0
		CnB.COM_Port.$ := CnB.Str_Prt_COM0
	ELSIF CnB.COM_Port.I == COM0 THEN
		CnB.COM_Port.I := COM1
		CnB.COM_Port.$ := CnB.Str_Prt_COM1
	ENDIF
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB


SUB CnB.COM_Port_SET_next_default_Baud
	IF    CnB.COM_Port.I == COM1 THEN
		CnB.COM_Port.I := COM2
		CnB.COM_Port.$ := CnB.Str_Prt_COM2
		CnB.BAUDRATE.I := Baud_38400
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ELSIF CnB.COM_Port.I == COM2 THEN
		CnB.COM_Port.I := COM0
		CnB.COM_Port.$ := CnB.Str_Prt_COM0
		CnB.BAUDRATE.I := Baud_250000
		CnB.Baudrate.$ := CnB.Str_BR_250000
	ELSIF CnB.COM_Port.I == COM0 THEN
		CnB.COM_Port.I := COM1
		CnB.COM_Port.$ := CnB.Str_Prt_COM1
		CnB.BAUDRATE.I := Baud_38400
		CnB.Baudrate.$ := CnB.Str_BR_38400
	ENDIF
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.COM_Port_SET
	CallSubroutine( CnB.COM_Port_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.COM_Port_SET_COM0
	; Setzen des neuen COM-Ports mit der aktuellen Baudrate
	CnB.COM_Port.I := COM0
	CallSubroutine( CnB.COM_Port_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.COM_Port_SET_COM1
	; Setzen des neuen COM-Ports mit der aktuellen Baudrate
	CnB.COM_Port.I := COM1
	CallSubroutine( CnB.COM_Port_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB

SUB CnB.COM_Port_SET_COM2
	; Setzen des neuen COM-Ports mit der aktuellen Baudrate
	CnB.COM_Port.I := COM2
	CallSubroutine( CnB.COM_Port_GET_Str )
	Serial.SetBaudrate( CnB.COM_Port.I , CnB.BAUDRATE.I )
ENDSUB



; COMBINED - Functions _____________________________________________


SUB CnB.COM_Port_Baudrate_SET_all_to_default
	; reset all to default value
	Serial.SetBaudrate( COM1 , Baud_38400 )
	Serial.SetBaudrate( COM2 , Baud_38400 )
	Serial.SetBaudrate( COM0 , Baud_250000 )
	CallSubroutine( CnB.Baudrate_SET_default )
ENDSUB


SUB CnB.COM_Port_Baudrate_SET_others_to_default
	IF CnB.COM_Port.I <> COM1 THEN
		Serial.SetBaudrate( COM1 , Baud_38400 )
	ENDIF

	IF CnB.COM_Port.I <> COM2 THEN
		Serial.SetBaudrate( COM2 , Baud_38400 )
	ENDIF

	IF CnB.COM_Port.I <> COM0 THEN
		Serial.SetBaudrate( COM0 , Baud_250000 )
	ENDIF
ENDSUB




