; 01.05.2005 ------------------------------------------------------- 14.11.2009

; eiger VM Token Definitions

; FileName:	Def_eVM_OpCodes_0$71.h

; Supported Hardware FOX1 Microcomputer and EVE-Anna Graphics Engine

; Copyright	S-TEC electronics AG
;		Industriestrasse 49
;		CH-6300 Zug
;		Switzerland
;		www.s-tec.ch
;		s-tec@bluewin.ch

; Autor		R. F. Oberhnsli


; Version	V1.01


; History	V0.00		10.06.2005	first release
; Version	V0.01; Datum: 07.02.2006
; Version	V0.02; update 17.03.2006
; Version	V0.03; update 03.04.2006
; Version	V0.04; update 26.07.2006
; Version	V0.35; update 05.08.2006
; Version	V0.40; update 12.09.2006	0$40
; Version	V0.40; update 06.10.2006	0$40
; Version	V0.45; update 10.10.2006	0$45
; Version	V0.50; update 06.01.2007	0$50
; Version	V0.50; update 09.02.2007	0$50 Binary long
; Version	V0.50; update 28.03.2007	0$50 Label verbessert, Str.ASCII_to_UInteger
; Version	V0.50; update 16.07.2007	0$50 Copy und Show- Funktionen
; Version	V0.50; update 20.07.2007	0$50 Byte in ARRAY schreiben/lesen
; Version	V0.50; update 11.08.2007	0$50 Time. Class
; Version 	V0.55; update 30.10.2007	0$55 Stackmachine  Math.EVAL
; Version 	V0.60; update 17.10.2007	0$60 System.Reset
; Version 	V0.60; update 14.02.2008	0$60 File.FileSize, File.FileExists
; Version 	V0.60; update 18.06.2008	0$60 Colors.PutRed etc.
; Version	V0.70; new    09.07.2008	Transfer.To_HotSpotInfo()
; Version	V0.70; new    02.09.2008	Draw.Char() 
; Version	V0.70; new    01.12.2008	eFA_PushIU_B
; Version	V0.70; new    13.12.2008	eFA_POW_S
; Version	V0.70; new    20.12.2008	HotSpot.DisableGroup(VarInt:Group)
;						HotSpot.EnableGroup(VarInt:Group)
; Version	V0.70; new    03.01.2009	Draw.RectangleFilledRound
; Version	V0.70; new    19.01.2009	File.Open
; Version	V0.70; new    19.10.2009	InOut.GetUpCounter
; 						InOut.ResetUpCounter	
; Version	V0.70; new    26.10.2009	I2C.Routinen
; Version	V0.70; new    01.11.2009	Str.Add_ProjectName
; Version	V0.70; new    14.11.2009	Buzzer
; Version	V0.71; new    20.07.2009	Serial.ReceiveToFile(VarInt:COMx,VarStr:FileName)
;      	                        	Serial.SendFromFile(VarInt:COMx,VarStr:FileName) 


; The tokens of the virtual machine are defined here


;------------------------------------------------------------------------------
; (c) 2005-2009    S-TEC electronics AG, CH-6300 Zug   041 754 50 10
;                  www.s-tec.ch			www.eigergrapics.com
;------------------------------------------------------------------------------


; ins SourceFile einfgen mit
; INCLUDEFILE	'Def_eVM_OpCodes_0$70.h'	; Tokendefinitionen 09.07.2008




; Token fr eigerVirtualMachine -----------------------------------------------


StartView		EQU	0xBC1E	; Start View
BEGINVIEW		EQU	0xBC1E	; Start View
ENDVIEW			EQU	0xBC1F	; Ende einer View
EndView			EQU	0xBC1F	; Ende einer View
Eiger			EQU	0xBC21	; Start eines Commands Achtung nicht ndern.
					; Interpreter sucht nach 0x21 und 0xBC, wenn OP-Code
					; falsch ist.

StartCommand		EQU	0xBC21	; Start eines Commands
BeginSub		EQU	0xBC22	; Start einer Subroutine
ENDSUB			EQU	0xBC23	; Ende einer Subroutine
EndSub			EQU	0xBC23	; Ende einer Subroutine
EndSequence		EQU	0xBC24	; Ende einer Codesequenz




; Diese Funktionen werden zwingend bentigt !!!!!! -----------------------------------------------------
; Die Funktionen in diesem Abschnitt werden vom eigerCompiler automatisch zugewiesen
LOAD_INTEGER		EQU	0x210A	; Integer-Variable mit immmediate Wert laden
LoadInteger		EQU	0x210A	; Integer-Variable mit immmediate Wert laden

LoadIntegerMulti	EQU	0x210B	; Multiple Integer-Variable mit immmediate Wert laden
LOAD_INTEGER_MULTI	EQU	0x210B	; Multiple Integer-Variable mit immmediate Wert laden

CallSubroutine		EQU	0x2120	; Neuer Code fr CallSubroutine			0$35		12.08.2006	
					; CallSubroutine(labelRelative24)

CallBack		EQU	0x2121	; CallBack an Absolute Addresse			Version 0$45	12.11.2006
					; CallBack(VarLong:CallBackAddress)


Math.MOVE_Byte		EQU	0x2123	; Byte verschieben		Y := A		Version_0$60	12.05.2008
					; Math.MOVE_Byte(VarByte:Y,VarByte:A)

MOVE_INTEGER		EQU	0x2124	; MOVE Integer  		Y := A		0$35
					; MOVE_INTEGER(VarInt:Y,VarInt:A)

Math.MOVE_Integer	EQU	0x2124	; Math.MOVE_Integer		Y := A		0$35 Compilerfunktion V0.30
					; Math.MOVE_Integer(VarInt:Y,VarInt:A)

MOVE_LONG		EQU	0x2125	; MOVE Long  (Resultat,Operand1) Y := A			; 24.08.2006
					; MOVE_LONG(VarLong,VarLong)				; eVM_Version_0$35


Math.MOVE_Long		EQU	0x2125	; Math.MOVE_Long(VarLong:Y,VarLong:A)		0$35 Compilerfunktion V0.30



;Math.MOVE_SINGLE	EQU	0x2126	; Singlezahl verschieben	Y := A		Version_0$45	29.11.2006	
					; Math.MOVE_SINGLE(VarSingle:Y,VarSingle:A)


Math.MOVE_Single	EQU	0x2126	; Singlezahl verschieben	Y := A		Version_0$45	29.11.2006	
					; Math.MOVE_SINGLE(VarSingle:Y,VarSingle:A)


					; nur Test, wird wieder entfernt.
MOVE_INTEGER_IO		EQU	0x5825	; MOVE Integer			Y := A		0$35
					; MOVE_INTEGER_IO(VarInt:A,VarInt:Y)

Experimental.NOP	EQU	0x5826	; NOP-Experimental
					; Experimental.NOP()

Experimental.ADD_STACK_Integer EQU 0x5827 ; Stack Addition		POP(A), POP(B), Y:= A+B, PUSH(Y)
					; Experimental.ADD_STACK_Integer()


;MoveInteger		EQU	0x000C	; Move Integer to another Integer
;Jump			EQU	0x000D	; Jump to Address
;JumpIntegerNotZero	EQU	0x000E	; Jump to Address if Variable is not zero
;JumpIntegerZero	EQU	0x000F	; Jump to Address if Variable is zero
*AddIntegerImmediate	EQU	0x0010	; Add immediate Value to Integer Variable
TextBox_A_InitFont	EQU	0x0012	; Font initialisieren fr Textausgabe in TextBox A
;DrawBorder		EQU	0x0013	; Zeichnet einen Rand im BorderStyle
TextBox_A_Init		EQU	0x0014	; Initialisiert TextBox A
TextBox_A_SetColors	EQU	0x0015	; Setzt die Text- und Hintergrundfarbe von TextBox A
TextBox_A_WriteText	EQU	0x0016	; Gibt anschliessenden Text aus. Abschluss mit Null
TextBox_A_Box		EQU	0x0017	; Zeichnet vergrsserte Box um das Textfeld.
;LabelText		EQU	0x0018	; Schreibt Text an X/Y-Position
;Delay_n_ms		EQU	0x0019	; holt die Wartezeit aus EI_Delay und wartet n ms
					; Delay.WaitRegister() benutzen



; DatenServer ------------------------------------------------------------------------------------------



DataServer.Rx_String	EQU	0x2803	; String ber den DatenServer von einen Knoten lesen
					; DataServer.Rx_String(VarInt:NodeAddress,VarInt:RegNo,VarStr:String)

DataServer.Tx_String	EQU	0x2804	; String ber den DatenServer an einen Knoten senden
					; DataServer.Tx_String(VarInt:NodeAddress,VarInt:RegNo,VarStr:String)

DataServer.Tx_Command	EQU	0x2805	; Command ber den DatenServer an einen Knoten senden
					; DataServer.Tx_Command(VarInt:NodeAddress,VarInt:Command)

DataServer.Rx_ReadInteger  EQU	0x2806	; Integer an Datenserver senden
					; DataServer.Rx_ReadInteger(VarInt:NodeAddress,VarInt:RegNo,VarInt:Value)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =

DataServer.Tx_WriteInteger  EQU	0x2807	; Integer an Datenserver scheiben			; 08.11.2006 V0$45
					; DataServer.Tx_WriteInteger(VarInt:NodeAddress,VarInt:RegNo,VarInt:Value)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =

DataServer.Rx_ReadLong  EQU	0x2808	; Integer an Datenserver senden				; 08.11.2006 V0$45
					; DataServer.Rx_ReadLong(VarInt:NodeAddress,VarInt:RegNo,VarLong:Value)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =

DataServer.Tx_WriteLong  EQU	0x2809	; Integer an Datenserver scheiben			; 08.11.2006 V0$45
					; DataServer.Tx_WriteLong(VarInt:NodeAddress,VarInt:RegNo,VarLong:Value)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =


DataServer.SendFromFile  EQU	0x280A	; File an Datenserver scheiben			; 13.06.2007 V0$50
					; DataServer.SendFromFile(VarInt:NodeAddress,VarStr:FileName)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =



DataServer.ReceiveToFile  EQU	0x280B	; File auf CFC speichern			; 13.06.2007 V0$50
					; DataServer.ReceiveToFile(VarInt:NodeAddress,VarStr:FileName)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =



DataServer.SendFromString  EQU	0x280C	; QuellString an Datenserver scheiben		; 05.07.2007 V0$50
					; DataServer.SendFromString(VarInt:NodeAddress,VarStr:QuellString)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =

DataServer.ReceiveToString  EQU	0x280D	; File auf String speichern			; 05.07.2007 V0$50
					; DataServer.ReceiveToString(VarInt:NodeAddress,VarStr:ZielString)
					; OPARM:
					; eI.Status = success ok
					; eI.Status = failed  Fehler
					; eI.ErrorCode = TimeOut
					; eI.ErrorCode =


;DataServer.ReadRegister	EQU	0x5300	; Server Register lesen
;DataServer.ReadInteger		EQU	0x5301	; Server Register Integer lesen
;DataServer.WriteInteger	EQU	0x5302	; Server Register schreiben



; String Funktionen ------------------------------------------------------------------------------------

					; $
;Str.Copy		EQU	0x2400	; String kopieren (obsolete neu Code 241C)
;					; Str.Copy(VarStr:ZielString,VarStr:QuellString) (VarStr,VarStr) 24.05.2006
Str.Length		EQU	0x2401	; Effektive Stringlnge bestimmen 'abc' hat die Lnge 3. Die Abschlussnull wird nicht gezhlt
					; Str.Length(VarInt,VarStr) Str.Length(EI_Int_2,PrintString) 25.05.2006
Str.Clear		EQU	0x2402	; String lschen Str.Clear(Zielstring) Str.Clear(VarStr) 26.05.2006
Str.AddChar		EQU	0x2403	; Character zu String anfgen Str.AddChar(VarStr,VarInt)

Str.Concat		EQU	0x2404	; Quellstring an ZielString anfgen 
					; Str.Concat(ZielString,QuellString) Str.Concat(VarStr,VarStr)

Str.BufferLength	EQU	0x2405	; BufferLnge eines Strings zurckliefern
			 		; Str.BufferLength(VarInt,VarStr)	
					; Str.BufferLength(EI_Int_2,PrintString)	; Bufferlnge von PrintString holen 28.05.2006

Str.UpperCase		EQU	0x2406	; String in Grossbuchstaben wandeln
					; Str.UpperCase(VarStr:ZielString) 	29.05.2006

Str.LowerCase		EQU	0x2407	; String in Kleinbuchstaben wandeln
					; Str.LowerCase(VarStr:ZielString)	29.05.2006

Str.Compare		EQU	0x2408	; 2 Strings miteinander vergleichen  
					; Str.Compare(Ergebnis,VergleichsString1,VergleichsString2)
					; Str.Compare(VarInt,VarStr,VarStr) 29.05.2006
					; OPARM:	Integer -1 String 1 kleiner als String 2
					;			 0 Strings sind gleich
					;			 1 String 1 ist grsser als String 2

Str.GetChar_at_Position	EQU	0x2409	; Str.GetChar_at_Position(eI.Int_1,eI.Int_2,'1''Hallo')	
					; eI.Int_1 ist der Character (Rckgabewert)
					; eI.Int_2 ist die Position
					; Startposition
					; String
					; Aus dem String wird das Zeichen an Position
					; EI_Int_2 in das Register EI_Int_1 bergeben.
					; Str.GetChar_at_Position(VarInt,VarInt,VarInt,VarStr)	

Str.GetPosition_by_Char	EQU	0x240A	; Str.GetPosition_by_Char(Fundposition,Char,StartPos,'String')
					; FundPosition (Rckgabewert)
					; EI_Int_2 Character
					; StartPosition in EI_Int_1
					; Der Character in EI_Int_2 wird im String gesucht
					; und die erste gefundene Position ab StartPosition wird zurckgegeben.
					; Falls das Zeichen nicht gefunden wurde, wird 0
					; zurckgegeben.
					; Str.GetPosition_by_Char(VarInt:FundPosition,VarInt:Char,VarInt:StartPosition,VarStr:InputString)


;Str.Cvt_Real		EQU	0x240B	; Str.Cvt_Real(VarStr,VarSingle,VarInt,VarInt)		31.05.2006
					; Str.Cvt_Real(ZielString,MyReal,5,3)	
					; MyReal in ZielString umwandeln mit 5 Vorkomma und 3 Nachkommastellen

Str.Cvt_Single		EQU	0x240B	; Str.Cvt_Single(VarStr:ZielString,VarSingle:Zahl,VarInt:Vorkomma,VarInt:Nachkomma)	19.01.2007
					; Str.Cvt_Single(ZielString,MyReal,5,3)	
					; MySingle in ZielString umwandeln mit 5 Vorkomma und 3 Nachkommastellen

Str.Cvt_WordHex		EQU	0x240C	; Str.Cvt_WordHex(ZielString,EI_Int_1)			31.05.2006
					; EI_Int_1 hexadezimal an ZielString anhngen
					; Str.Cvt_WordHex(VarStr,VarInt)

Str.Cvt_Long		EQU	0x240D	; Str.Cvt_Long(ZielString,MyLong1,6)			16.06.2006
					; VarLong umwandeln und mit Anzahl Stellen an String anhngen
					; Str.Cvt_Long(VarStr,VarLong,VarInt)

Str.Cvt_LongHex		EQU	0x240E	; Str.Cvt_LongHex(ZielString,MyLong1)			16.06.2006
					; VarLong umwandeln und hexadezimal an String anhngen
					; Str.Cvt_LongHex(VarStr,VarLong)

Str.Cvt_LongDeci	EQU	0x240F	; Str.Cvt_LongDeci(VarStr,VarLong,VarInt,VarInt)	22.06.2006
					; Varlong umwandeln mit Feldlnge und Nachkommastellen

Str.Cvt_Integer		EQU	0x2410	; Str.Cvt_Integer(VarStr,VarInt,VarInt)			26.06.2006
					; Str.Cvt_Integer(ZielString,Floor,3)

Str.Cvt_UInteger	EQU	0x2411	; Str.Cvt_UInteger(VarStr,VarInt,VarInt)		26.06.2006
					; Str.Cvt_UInteger(ZielString,Floor,3)


Str.Cvt_IntegerDeci	EQU	0x2412	; Str.Cvt_IntegerDeci(VarStr,VarInt,VarInt,VarInt)	26.06.2006
					; Str.Cvt_IntegerDeci(ZielString,Floor,4,1)

Str.Cvt_UIntegerDeci	EQU	0x2413	; Str.Cvt_UIntegerDeci(VarStr,VarInt,VarInt,VarInt)	26.06.2006
					; Str.Cvt_UIntegerDeci(ZielString,Floor,4,1)
					; unsigned Integer mit Nachkommastellen ausgeben

Str.Find		EQU	0x2414	; Str.Find(InputString,1,'Fridolin',StringPosition)	01.07.2006
					; Str.Find(VarStr,VarInt,VarStr,VarInt)
					; Vergleicht ab Startposition und liefert in StringPosition 0 zurck,
					; wenn nicht gefunden und sonst die erste Stelle nach dem gefundenen String

Str.SkipBlank		EQU	0x2415	; Str.SkipBlank(InputString,StartPosition,FindPosition) ; Whitespace berlesen
					; Str.SkipBlank(VarStr:String,VarInt:StartPosition,VarInt:FindPosition)
					;						02.07.2006
					; bringt Position auf nchstes Zeichen, das nicht Whitespace ist
					; WhiteSpace Character = 0x20, 0x09, 0xA0

Str.SpaceInString	EQU	0x2416	; 16 (Rest)Platz im String bestimmen		02.07.2006
					; Str.SpaceInString(VarInt:Space,VarStr:QuellString)

Str.Cvt_ByteHex		EQU	0x2417	; Str.Cvt_ByteHex(ZielString,EI_Int_1) 		08.07.2006
					; EI_Int_1 hexadezimal an ZielString anhngen
					; Str.Cvt_ByteHex(VarStr,VarInt)

Str.RemoveLastChar	EQU	0x2418	; Str.RemoveLastChar				18.07.2006
					; Str.RemoveLastChar(VarInt:RemovedChar,VarStr:String)

Str.ASCII_to_WordHex	EQU	0x2419	; Str.ASCII_to_WordHex				26.07.2006
					; Str.ASCII_to_WordHex(VarInt:Number,VarStr:InputString,VarInt:Position)
					; EI_Status [error  success]	
					; EI_ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]

Str.ASCII_to_LongHex	EQU	0x241A	; Str.ASCII_to_LongHex				27.07.2006
					; Str.ASCII_to_LongHex(VarLong:Number,VarStr:InputString,VarInt:Position)
					; EI_Status [error  success]	
					; EI_ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]


Str.PutChar_at_Position	EQU	0x241B	; Char an Position in String schreiben		; Version 0$40 21.09.2006
					; Str.PutChar_at_Position(VarInt:Char,VarInt:Position,VarStr:QuellString)

Str.Copy		EQU	0x241C	; String kopieren				; Version 0$40 21.09.2006
					; Str.Copy(VarStr:ZielString,VarStr:QuellString) (VarStr,VarStr) 24.05.2006



Str.ASCII_to_ByteHex	EQU	0x241D	; Str.ASCII_to_ByteHex				; Version 0$45 14.10.2006
					; Str.ASCII_to_ByteHex(VarInt:Number,VarStr:InputString,VarInt:Position)
					; EI_Status error, falls Fehler	
					; EI_ErrorCode: 
					; WARINS.STRING_NotInHex	kein HEX-Zeichen wo erwartet
					; ERRINS.STRING_OutOfString	Position zeigt ausserhalb String
					; WARINS.STRING_EmptyString	leerer String


Str.FillUpWithChar	EQU	0x241E	; String mit Character auffllen		; Version 0$45 14.10.2006
					; Str.FillUpWithChar(VarStr:ZielString,VarInt:Character)


Str.WriteSubString	EQU	0x241F	; SubString in String schreiben			; Version 0$45 14.10.2006
					; Str.WriteSubString(VarStr:ZielString,VarInt:Position,VarStr:QuellString)

Str.Add_CRLF		EQU	0x2420	; CRLF ans Stringende anhngen			; Version 0$45 29.10.2006
					; Str.Add_CRLF(VarStr:ZielString)


Str.CopySubstringWord	EQU	0x2421	; Wort aus QuellString in Zielstring bertragen	; Version 0$45 01.11.2006
					; Str.CopySubstringWord(VarStr:Ziel,VarStr:Quelle,VarInt:Pos)


Str.RemoveChar_at_Position  EQU	0x2422	; Character an Position entfernen.		; Version 0$45 03.11.2006
					; Die Stringlnge vermidert sich um 1.
					; Str.RemoveChar_At_Position(VarInt:RemovedChar,VarStr:String,VarInt:Position)

Str.CopySubstring_to_LineEnd EQU 0x2423 ; Alle Characters bis und mit Zeilenende kopieren  ; Version 0$45 03.11.2006
					; Str.CopySubstring_to_LineEnd(VarStr:Ziel,VarStr:Quelle,VarInt:Pos,VarInt:NewPos)


Str.MovePosition_to_LineNo EQU	0x2424	; Position aus ZeilenNummer bestimmen		; Version 0$45 03.11.2006
					; Str.MovePosition_to_LineNo(VarStr:Quelle,VarInt:LineNo,VarInt:NewPos)


Str.ASCII_to_Long	EQU	0x2425	; ganzzahlige Longzahl einlesen			; Version 0$45 09.11.2006
					; Str.ASCII_to_Long(VarLong:Number,VarStr:InputString,VarInt:Position)

Str.ASCII_to_LongDeci	EQU	0x2426	; Longzahl als Dezimalzahl auffassen und einlesen Version 0$45 11.11.2006
					; Str.ASCII_to_LongDeci(VarLong:Number,VarStr:InputString,VarInt:Position,VarInt:Nachkomma)


Str.ASCII_to_HighColor	EQU	0x2427	; Farbe im WEB-Format (z.B. #3366FF) einlesen	; Version 0$45 14.11.2006
					; Str.ASCII_to_HighColor(VarInt:Color,VarStr:InputString,VarInt:Position)


Str.Match		EQU	0x2428	; String auf bereinstimmung untersuchen ab Position ; Version 0$45 24.11.2006
					; Str.Match(VarStr:VergleichString,VarInt:StartPosition,VarStr:SuchString)
					; in eI.Boolean wird true oder false zurckgeliefert.

Str.MovePosition_to_NextLine  EQU 0x2429	; Position auf nchsten Zeilenanfang bringen	; Version 0$45 25.11.2006
					; Str.MovePosition_to_NextLine(VarStr:Quelle,VarInt:LineNo,VarInt:NewPos)

Str.ASCII_to_UInteger	EQU	0x242A	; ganzzahlige UIntegerzahl einlesen		; Version 0$50 28.03.2007
					; Str.ASCII_to_UInteger(VarInt:Number,VarStr:InputString,VarInt:Position)

Str.ASCII_to_Integer	EQU	0x242B	; ganzzahlige Integerzahl einlesen		; Version 0$50 28.03.2007
					; Str.ASCII_to_Integer(VarInt:Number,VarStr:InputString,VarInt:Position)


Str.ConcatMove		EQU	0x242C	; zwei Strings zusammenfgen und in Zielstring speichern 0$50	02.04.2007
					; Str.ConcatMove(VarStr:ZielString,VarStr:QuellString1,VarStr:QuellString2)


Str.InsertChar_at_Position  EQU	0x242D	; Character an Position einfgen.		; Version 0$50 15.05.2007
					; Die Stringlnge erhht sich um 1.
					; Str.InsertChar_at_Position(VarInt:Char,VarInt:Position,VarStr:String)

Str.Insert_n_Chars_at_Position  EQU 0x242E	; n Characters an Position einfgen.	; Version 0$50 15.05.2007
					; Die Stringlnge erhht sich um n.
					; Str.Insert_n_Chars_at_Position(VarInt:Char,VarInt:Position,VarInt:NumberOfChars,VarStr:String)


Str.Left		EQU	0x242F	; Weist die ersten NoOfChars von QuellString	; Version 0$50 31.07.2007 
					; an ZielString zu. Wenn NoOfChars zu gross ist, wird das bestmgliche
					; Resultat zurckgeliefert						 
					; Str.Left(VarStr:ZielString,VarStr:InputString,VarInt:NoOfChars)


Str.Right		EQU	0x2430	; Weist die n Char von der rechten Seite zu				; Version 0$50 31.07.2007 
					; Str.Right(VarStr:ZielString,VarStr:Inputtring,VarInt:NoOfChars)


Str.Mid			EQU	0x2431	; Weist n Char ab Position zu						; Version 0$50 31.07.2007 
					; Str.Mid(VarStr:ZielString,VarStr:InputString,VarInt:Position,VarInt:NoOfChars)



Str.Time		EQU	0x2432	; Fgt die Zeit im angegebenen Format an
					; Str.Time(VarStr:ZielString,VarInt:FormatTime)				

					; Die Zeit steht in folgenden Registern:
					; eI.MSEC
					; eI.SEC
					; eI.MIN
					; eI.HOURS
					
					; Die Register knnen entweder einfach mit
					; Integern beschrieben werden, oder mit der Funktion
					; Time.Get() von der Echtzeituhr geholt werden.


Str.Date		EQU	0x2433	; Fgt die Zeit im angegebenen Format an
					; Str.Date(VarStr:ZielString,VarInt:FormatDate)

					; Das Datum steht in folgenden Registern:
					; eI.DATE
					; eI.MONTH
					; eI.YEAR
					
					; Die Register knnen entweder einfach mit
					; Integern beschrieben werden, oder mit der Funktion
					; Time.Date() von der Echtzeituhr geholt werden.




Str.Checksum		EQU	0x2434	; Berechnet die Prfsumme eines Strings
					; Str.Checksum(VarStr:String,VarInt:ChecksumFunction,VarInt:Checksum)



Str.RemoveWhiteSpace_at_Position  EQU 0x2435	
					; WhiteSpace an Position entfernen
					; Str.RemoveWhiteSpace_at_Position(VarInt:NonWhiteSpaceChar,VarStr:String,VarInt:Position)


Str.Add_ProjectName	EQU	0x2436	; 					Version 0$70 01.11.2009
					; fgt dem ZielString 4 Character des ProjectName an
					; Str.Add_ProjectName(VarStr:ZielString)


Value.ByteHex		EQU	0x241D	; Value.ByteHex				Version 0$50 31.07.2007
					; Value.ByteHex(VarInt:Number,VarStr:InputString,VarInt:Position)
					; EI_Status error, falls Fehler	
					; EI_ErrorCode: 
					; WARINS.STRING_NotInHex	kein HEX-Zeichen wo erwartet
					; ERRINS.STRING_OutOfString	Position zeigt ausserhalb String
					; WARINS.STRING_EmptyString	leerer String


Value.WordHex		EQU	0x2419	; Value.WordHex					; Version 0$50 31.07.2007
					; Value.WordHex(VarInt:Number,VarStr:InputString,VarInt:Position)
					; EI_Status [error  success]
					; EI_ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]


Value.LongHex		EQU	0x241A	; Value.LongHex					; Version 0$50 31.07.2007
					; Value.LongHex(VarLong:Number,VarStr:InputString,VarInt:Position)
					; EI_Status [error  success]
					; EI_ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]

Value.Long		EQU	0x2425	; ganzzahlige Longzahl einlesen			; Version 0$50 31.07.2007
					; Value.Long(VarLong:Number,VarStr:InputString,VarInt:Position)

Value.LongDeci		EQU	0x2426	; Longzahl als Dezimalzahl auffassen und einlesen Version 0$45 11.11.2006
					; Value.LongDeci(VarLong:Number,VarStr:InputString,VarInt:Position,VarInt:Nachkomma)


Value.UInteger		EQU	0x242A	; ganzzahlige UIntegerzahl einlesen		; Version 0$50 31.07.2007
					; Value.UInteger(VarInt:Number,VarStr:InputString,VarInt:Position)

Value.Integer		EQU	0x242B	; ganzzahlige Integerzahl einlesen		; Version 0$50 31.07.2007
					; Value.Integer(VarInt:Number,VarStr:InputString,VarInt:Position)

Value.HighColor		EQU	0x2427	; Farbe im WEB-Format (z.B. #3366FF) einlesen	; Version 0$50 31.07.2007
					; Value.HighColor(VarInt:Color,VarStr:InputString,VarInt:Position)


					; %
;Serial.Tx_String	EQU	0x2500	; UART-Ausgabe auf serielle Schnittstelle   Serial.Tx_String(COM2,'Hallo')
;					; UART-Ausgabe auf COM2-Schnittstelle       Serial.Tx_String(VarInt,VarStr) 26.05.2006

Serial.Tx_CRLF		EQU	0x2501	; UART-Ausgabe von CRLF auf serielle Schnittstelle Serial.Tx_CRLF(Kanal) Serial.Tx_CRLF(COM1) 27.05.2006
Serial.Tx_NUL		EQU	0x2502	; UART-Ausgabe von NUL  auf serielle Schnittstelle Serial.Tx_NUL(Kanal) Serial.Tx_NUL(COM1) 27.05.2006

Serial.Tx_Char		EQU	0x2503	; UART-Ausgabe von Character  auf serielle Schnittstelle
					; Serial.Tx_Char(Kanal,CharacterVariable)
					; Serial.Tx_Char(VarInt,VarInt) 
					; Serial.Tx_NUL(COM1,"B") 28.05.2006

Serial.Tx_String	EQU	0x2504	; UART-Ausgabe auf serielle Schnittstelle   Serial.Tx_String(COM2,'Hallo') V0$40
					; UART-Ausgabe auf COM2-Schnittstelle       Serial.Tx_String(VarInt,VarStr) 26.09.2006


					; InputString SerialServer einlesen ---------------------------------------
Serial.Rx_InBuf_to_String_Append EQU 0x2510 ; Serial.Rx_InputBuffer_to_String(COM1,InputString)
					; Serial.Rx_InputBuffer_to_String(VarInt,VarStr)

Serial.Rx_InBuf_Clear	EQU	0x2511	; Serial.Rx_InputBuffer_Clear(COM1)
					; Serial.Rx_InputBuffer_Clear(VarInt:COMx)

Serial.Rx_MonitorSlot_InstallLocal EQU 0x2512 ; Lokaler Zeichen-Monitor aufsetzen 
					; Kanal COM1..
					; Slot gibt an, welcher Slot geladen wird
					; LabelRelative24: Eventhandler
					; Verleichscharacter Low  (inklusiv)
					; Vergleichscharacter High (inklusiv)
					; Serial.Rx_Monitor_InstallLocal(VarInt:COM1,VarInt:Slot,labelRelative24:EventHandler,VarInt:CharLO,VarInt:CharHI)

Serial.Rx_MonitorSlot_Enable	EQU	0x2513	; Slot einschalten				22.09.2006 V0$40
					; Serial.Rx_MonitorSlot_Enable(VarInt:COM1,VarInt:Slot)

Serial.Rx_MonitorSlot_Disable	EQU	0x2514	; Slot sperren					22.09.2006 V0$40
					; Serial.Rx_MonitorSlot_Disable(VarInt:COM1,VarInt:Slot)

Serial.Rx_Get_EventChar		EQU	0x2515	; Zeichen, das Event ausgelst hat, einlesen	23.09.2006 V0$40
					; Serial.Rx_Get_EventChar(VarInt:COM1,VarInt:Char)


Serial.Rx_Monitor_DisableLocal	EQU	0x2516	; Alle lokalen Slots sperren			24.09.2006 V0$40
					; Serial.Rx_Monitor_DisableLocal(VarInt:COM1)


Serial.Rx_Monitor_EnableLocal	EQU	0x2517	; Alle lokalen Slots freigeben			24.09.2006 V0$40
					; Serial.Rx_Monitor_EnableLocal(VarInt:COM1)

Serial.Rx_Monitor_ClearLocal	EQU	0x2518	; Alle lokalen Slots lschen			24.09.2006 V0$40
					; Serial.Rx_Monitor_ClearLocal(VarInt:COM1)

Serial.Rx_Monitor_ScanContinue	EQU	0x2519	; weiterfahren mit scannen			20.02.2007 V0$50
					; Serial.Rx_Monitor_ScanContinue(VarInt:COM1)

Serial.SetBaudrate		EQU	0x251A	; Baudrate eines Kanals einstellen		29.05.2007 V0$50
					; Serial.SetBaudrate(VarInt:COM1,VarInt:Baud_9600)

Serial.Rx_InBuf_Length		EQU	0x251B	; Anzahl Zeichen im InBuf zurckgeben		19.08.2007 V0$50
					; Serial.Rx_InBuf_Length(VarInt:COMx,VarInt:Length)	
					; in eI.Garbage wird der Character gespeichert

Serial.Rx_InBuf_LastChar	EQU	0x251C	; Letztes Zeichen im InBuf zurckgeben		19.08.2007 V0$50
					; Serial.Rx_InBuf_LastChar(VarInt:COMx,VarInt:Length)
					; in eI.Garbage wird die Lnge gespeichert

Serial.Rx_Char			EQU	0x251D	; Zeichen von serieller Schnittstelle einlesen
					; -1 = kein Zeichen in Schnittstelle
					; 0..255 empfangenes Zeichen
					; Serial.Rx_Char(VarInt:COMx,VarInt:Char)

Serial.ReceiveToFile			EQU	0x251E	; Datei von serieller Schnittstelle einlesen
					; VarLong: FileLength = effektive Dateilnge
					; Serial.ReceiveToFile(VarInt:COMx,VarStr:FileName)
Serial.SendFromFile			EQU	0x251F	; Datei an serielle Schnittstelle senden
					; Serial.SendFromFile(VarInt:COMx,VarStr:FileName)
; Mathematik Integer -----------------------------------------------------------------------------------
; Klasse: EVM_MathInteger


Math.ADD_Integer	EQU	0x2601	; Math.ADD_Integer Y:= A + B (Y,A,B)		; 19.08.2006
					; Math.ADD_Integer(VarInt,VarInt,VarInt)	; eVM_Version_0$35


Math.SUB_Integer	EQU	0x2602	; Math.SUB_Integer Y:= A - B (Y,A,B)		; 19.08.2006
					; Math.SUB_Integer(VarInt,VarInt,VarInt)	; eVM_Version_0$35


Math.DIV_Integer	EQU	0x2603	; DIV_Integer (Resultat,Operand1,Operand2) 	; 23.08.2006
					; Math.DIV_Integer(VarInt,VarInt,VarInt)	; eVM_Version_0$35


Math.MOD_Integer	EQU	0x2604	; MOD_Integer (Resultat,Operand1,Operand2)	; 26.08.2006
					; Math.MOD_Integer(VarInt,VarInt,VarInt)	; eVM_Version_0$35




Math.MULS_Integer	EQU	0x2607	; Math.MULS_Integer Y:= A * B (Y,A,B)		; 20.08.2006
					; Math.MULS_Integer(VarInt,VarInt,VarInt)	; eVM_Version_0$35

Math.MUL_Integer	EQU	0x2607	; Math.MUL_Integer Y:= A * B (Y,A,B)		; 13.10.2006
					; Math.MUL_Integer(VarInt,VarInt,VarInt)	; eVM_Version_0$45 fr Compiler

Math.INC_Integer	EQU	0x2608	; Math.INC_Integer Y := Y + 1			; 19.08.2006
					; Math.INC_Integer (VarInt)			; eVM_Version_0$35

Math.DEC_Integer	EQU	0x2609	; Math.DEC_Integer Y := Y - 1			; 20.08.2006
					; Math.INC_Integer (VarInt)			; eVM_Version_0$35

Math.NEG_Integer	EQU	0x2612	; NEG Integer Y:= -A				; 10.10.2006
					; Math.INC_Integer (VarInt:Y,VarInt:A)		; eVM_Version_0$45

Math.ABS_Integer	EQU	0x2613	; ABS Integer  Y:= A				; 10.10.2006
					; Math.ABS_Integer(VarInt:Y,VarInt:A)		; eVM_Version_0$45	

Math.MIN_Integer	EQU	0x2614	; Minimum von Zahl A und Zahl B zurckliefern		11.11.2006
					; Math.MIN_Integer(VarInt:MIN,VarInt:A,VarInt:B)	eVM_Version_0$45

Math.MAX_Integer	EQU	0x2615	; Maximum von Zahl A und Zahl A zurckliefern		11.11.2006
					; Math.MAX_Integer(VarInt:MAX,VarInt:Zahl,VarInt:Zahl)	eVM_Version_0$45

Math.MEAN_Integer	EQU	0x2616	; Mittelwert von zwei Zahlen bestimmen 			11.11.2006
					; Math.MEAN_Integer(VarInt:MEAN,VarInt:A,VarInt:B)	eVM_Version_0$45

Math.LWRD_from_Long	EQU	0x2617	; Low Word aus einem Long lesen				19.11.2006
					; Math.LWRD_from_Long(VarInt:Integer,VarLong:Long)	eVM_Version_0$45

Math.LWRD_to_Long	EQU	0x2618	; Low Word in ein Long schreiben			19.11.2006
					; Math.LWRD_to_Long(VarLong:Long,VarInt:Integer)	eVM_Version_0$45

Math.HWRD_from_Long	EQU	0x2619	; High Word aus einem Long lesen			19.11.2006
					; Math.HWRD_from_Long(VarInt:Integer,VarLong:Long)	eVM_Version_0$45

Math.HWRD_to_Long	EQU	0x261A	; High Word in ein Long schreiben			19.11.2006
					; Math.HWRD_to_Long(VarLong:Long,VarInt:Integer)	eVM_Version_0$45


Math.Formula_Evaluator	EQU	0x261F	; experimenteller Formula Evaluator		; 23.08.2006
					; Math.Formula_Evaluator()



; Math.EVAL_Integer	EQU	0x261F	; Math Formula Evaluator Integer
; Math.EVAL_Long	EQU	0x261F	; Math Formula Evaluator Long
Math.EVAL               EQU 	0x261F  ; universelle Stackmaschine

Math.SM_Get_SP		EQU	0x261E	; Stackpointer der StackMachine holen		; 12.05.2008
					; Math.SM_Get_SP(VarInt:StackPointer)


;------------------------------------------------------------------------------------------
; Opcodes (8bit !!!) fr die Stackmaschine
; (ergnzt Juni 2007, aw)
; (ergnzt November 2007, RFO)

; In little endian Schreibweise kommt zuerst das LSB und dann das MSB

;	IntegerWert:	0xNN	0xNN		
;	Register:	0xRR	0xRR
;	Variable:	0xVV	0xVV	0xVV



eFA_NOP		        EQU     0x00            ; NOP no operation (*)
eFA_CVT_I_I		EQU	0x00		; nur zum testen, wird wieder entfernt
eFA_PushIU_B		EQU	0x01		; Push immediate unsigned byte		06.12.2008
						; 0x01 0xNN
eFA_PushI_UI            EQU     0x02            ; Push immediate unsigned integer	18.11.2007 tested
						; 0x02 0xNN 0xNN

eFA_PushIU_I		EQU	0x02		; 29.03.2009 ergnzt, Syntax prfen

eFA_PushI_I             EQU     0x03            ; Push immediate integer (*)		tested
						; 0x03 0xNN 0xNN

eFA_PushR_I             EQU     0x04            ; Push Register integer (*)
						; 0x03 0xRR 0xRR

eFA_PushV_I             EQU     0x05            ; Push Variable integer (*)		
						; 0x03 0xVV 0xVV 0xVV

eFA_PushV_L             EQU     0x06            ; Push Variable Long			17.11.2007 tested
						; 0x03 0xVV 0xVV 0xVV

eFA_PushI_L             EQU     0x07            ; Push immediate Long			17.11.2007 tested
						; 0x07 0xNN 0xNN 0xNN 0xNN

eFA_PushI_B             EQU     0x08            ; Push immediate Byte 			17.11.2007 tested
						; 0x08 0xNN


;eFA_CVT_S_I             EQU     0x09            ; Convert Single to Integer (direkt auf dem Stack)
;eFA_CVT_D_I             EQU     0x0A            ; Convert Double to Integer (direkt auf dem Stack)

eFA_PopV_LI             EQU     0x0B            ; Pop Variable logic integer	18.11.2007 
eFA_PopR_I              EQU     0x0C            ; Pop Register integer (*)
eFA_PopV_I              EQU     0x0D            ; Pop local Variable integer (*)
eFA_PopV_I              EQU     0x0D            ; Pop local Variable integer (*)
eFA_PopV_L              EQU     0x0E            ; Pop local Variable Long
eFA_PopV_UI             EQU     0x0F            ; Pop local Variable unsigned integer (*)

eFA_ADD_I               EQU     0x10            ; Stack Addition integer (*)
eFA_SUB_I               EQU     0x11            ; Stack Subtraktion integer (*)
eFA_MUL_I               EQU     0x12            ; Stack Multiplikation integer (*)
eFA_DIV_I               EQU     0x13            ; Stack Division integer (*)

eFA_POW_S               EQU     0x1C            ; Powerfunktion x^y
eFA_ABS_S               EQU     0x1D            ; Betragsfunktion
eFA_LN_S                EQU     0x1E            ; Natrlicher Logarithmus
eFA_LOG_S               EQU     0x1F            ; Logarithmus zur Basis 10

eFA_PushV_S             EQU     0x20            ; PUSH Variable Single
Math.Push_Single        EQU     0x21            ; PUHS immediate single	PUSH_ImmSinlge
eFA_PopV_S              EQU     0x22            ; POP Variable Single
eFA_ADD_S               EQU     0x23            ; Stack Addition Single
eFA_SUB_S               EQU     0x24            ; Stack Subtraktion Single
eFA_MUL_S               EQU     0x25            ; Stack Multiplikation Single
eFA_DIV_S               EQU     0x26            ; Stack Division Single
eFA_SIN_S               EQU     0x27            ; Sinus (Single)
eFA_COS_S               EQU     0x28            ; Cosinus (Single)
eFA_TAN_S               EQU     0x29            ; Tangens (Single)
eFA_EXP_S               EQU     0x2A            ; Exponentialfunktion (natrlich) e^x
eFA_SQR_S               EQU     0x2B            ; Quadratfunktion a^2
eFA_SQRT_S              EQU     0x2C            ; Quadratwurzel a
eFA_ARCSIN_S            EQU     0x2D            ; Arcus-Sinus (Single)
eFA_ARCCOS_S            EQU     0x2E            ; Arcus-Cosinus (Single)
eFA_ARCTAN_S            EQU     0x2F            ; Arcus-Tangens (Single)

eFA_PUSH_ADR24		EQU	0x30		; PUSH Address24

eFA_ADDR_ToElement	EQU	0x32		; Elementadresse aus Index berechnen


			; "Baggerschaufeln", um ARRAY-Elemente zu holen/versorgen --------------
eFA_PUSH_FromAddrInt	EQU	0x34		; Integer an Addresse auf Stack pushen
eFA_POP_ToAddrInt	EQU	0x35		; Integer auf Stack zu Adresse speichern
eFA_PUSH_FromAddrUInt	EQU	0x36		; UInteger an Addresse auf Stack pushen
eFA_POP_ToAddrUInt	EQU	0x37		; UInteger auf Stack zu Adresse speichern
eFA_PUSH_FromAddrLong	EQU	0x38		; Long an Addresse auf Stack pushen
eFA_POP_ToAddrLong	EQU	0x39		; Long auf Stack zu Adresse speichern
eFA_PUSH_FromAddrSingle	EQU	0x3A		; Single an Addresse auf Stack pushen
eFA_POP_ToAddrSingle	EQU	0x3B		; Single auf Stack zu Adresse speichern







;eFA_ABS_I               EQU     0x25            ; Betragsfunktion fr ganze Zahlen






;eFA_CVT_I_S             EQU     0x37            ; Convert Integer to Single (direkt auf dem Stack)
;eFA_CVT_D_S             EQU     0x38            ; Convert Double to Single (direkt auf dem Stack)




;eFA_PI_S                EQU     0x4D            ; Pi (Single, direkt auf den Stack; Tipp: Realisation mit 4*Arctan(1))

;eFA_PWR_S               EQU     0x4F            ; Allgemeine Potenzfunktion a^b





;eFA_PushV_D             EQU     0x65            ; Push Variable Double

;eFA_CVT_I_D             EQU     0x67            ; Convert Integer to Double (direkt auf dem Stack)
;eFA_CVT_S_D             EQU     0x68            ; Convert Single to Double (direkt auf dem Stack)


;eFA_PopV_D              EQU     0x6D            ; Pop Variable Double


;eFA_ADD_D               EQU     0x70            ; Stack Addition Double
;eFA_DUB_D               EQU     0x71            ; Stack Subtraktion Double
;eFA_MUL_D               EQU     0x72            ; Stack Multiplikation Double
;eFA_DIV_D               EQU     0x73            ; Stack Division Double

;eFA_DIN_D               EQU     0x75            ; Sinus (Double)
;eFA_COS_D               EQU     0x76            ; Cosinus (Double)
;eFA_TAN_D               EQU     0x77            ; Tangens (Double)

;eFA_ARCSIN_D            EQU     0x79            ; Arcus-Sinus (Double)
;eFA_ARCCOS_D            EQU     0x7A            ; Arcus-Cosinus (Double)
;eFA_ARCTAN_D            EQU     0x7B            ; Arcus-Tangens (Double)

;eFA_PI_D                EQU     0x7D            ; Pi (Double, direkt auf den Stack; Tipp: Realisation mit 4*Arctan(1))

;eFA_PWR_D               EQU     0x7F            ; Allgemeine Potenzfunktion a^b (Double)
;eFA_DQR_D               EQU     0x80            ; Quadratfunktion a^2 (Double)
;eFA_DQRT_D              EQU     0x81            ; Quadratwurzel (Double)
;eFA_EXP_D               EQU     0x82            ; Exponentialfunktion (natrlich) e^x (Double)
;eFA_LOG_D               EQU     0x83            ; Logarithmus zur Basis 10 (Double)
;eFA_LN_D                EQU     0x84            ; Natrlicher Logarithmus (Double)
;eFA_ABS_D               EQU     0x85            ; Betragsfunktion (Double)


eFA_END                 EQU     0xED            ; Endmarke der Befehlskette

;
; (Ende Opcodes fr die universelle Stackmaschine)
;------------------------------------------------------------------------------------------




;Math.NOT_Integer	EQU	0x4D11	; NOT Integer(Resultat,Operand1)	  (VarInt,VarInt)
;Math.NEG_Integer	EQU	0x4D12	; NEG Integer(Resultat,Operand1)	  (VarInt,VarInt)
;Math.ABS_Integer	EQU	0x4D13	; ABS Integer(Resultat,Operand1)	  (VarInt,VarInt)
;Math.MIN_Integer	EQU	0x4D14	; Minimum von Zahl 1 und Zahl 2 zurckliefern		3.8.2006
					; Math.MIN_Integer(VarInt:MIN,VarInt:Zahl,VarInt:Zahl)
;Math.MAX_Integer	EQU	0x4D15	; Maximum von Zahl 1 und Zahl 2 zurckliefern		3.8.2006
					; Math.MAX_Integer(VarInt:MAX,VarInt:Zahl,VarInt:Zahl)
;Math.MEAN_Integer	EQU	0x4D16	; Mittelwert von zwei Zahlen bestimmen 			3.8.2006
					; Math.MEAN_Integer(VarInt:MEAN,VarInt:Zahl,VarInt:Zahl)




; Binre Operationen  ---------------------------------------------------------------------------------------
; Klasse eVM_Binary




Binary.BSET_Integer	EQU	0x4208	; Bit, das durch BitNummer angegeben ist	15.08.2006
					; in einem Integerwert setzen
					; Binary.BSET_Integer(VarInt:Ziel,VarInt:BitNo)

Binary.BCLR_Integer	EQU	0x4209	; Bit lschen, das durch BitNummer angegeben ist 15.08.2006
					; in einem Integerwert setzen
					; Binary.BCLR_Integer(VarInt:Ziel,VarInt:BitNo)

Binary.BNOT_Integer	EQU	0x420A	; Bit invertieren, das durch BitNummer angegeben ist 15.08.2006
					; in einem Integerwert setzen
					; Binary.NOT_Bit(VarInt:Ziel,VarInt:BitNo)






Binary.AND_Integer	EQU	0x4210	; AND zweier Integer Q := A AND B	15.08.2006	0$35
					; Binary.AND_Integer(VarInt:Q,VarInt:A,VarInt:B)

Binary.OR_Integer	EQU	0x4211	; OR zweier Integer  Q := A OR B	18.08.2006	0$35
					; Binary.OR_Integer(VarInt:Q,VarInt:A,VarInt:B)

Binary.XOR_Integer	EQU	0x4212	; XOR zweier Integer Q := A XOR B	18.08.2006	0$35
					; Binary.XOR_Integer(VarInt:Q,VarInt:A,VarInt:B)

Binary.ROTATE_LEFT_Integer EQU	0x4213	; Integer wird links rotiert		18.02.2007	0$50
					; Binary.ROTATE_LEFT_Integer(VarInt:Quelle_Ziel,VarInt:Anzahl_Bits) 0..16
					; das links herausgeschobene Bit landet in eI.Boolean

Binary.ROTATE_RIGHT_Integer EQU	0x4214	; Integer wird rechts rotiert		18.02.2007	0$50
					; Binary.ROTATE_RIGHT_Integer(VarInt:Quelle_Ziel,VarInt:Anzahl_Bits) 0..16
					; das rechts herausgeschobene Bit landet in eI.Boolean


Binary.NOT_Integer	EQU	0x4218	; NOT zweier Integer Q := NOT A		18.08.2006	0$35
					; Binary.NOT_Integer(VarInt:Q,VarInt:A)

Binary.SWAP_BYTE_Integer EQU	0x4219	; HighByte und LowByte tauschen		10.02.2006	0$50
					; Binary.SWAP_BYTE_Integer(VarInt:Q,VarInt:A)




Binary.BSET_Long	EQU	0x4228	; Bit, das durch BitNummer angegeben ist		18.02.2007
					; in einem Longwert setzen				0$50
					; Binary.BSET_Long(VarLong:Ziel,VarInt:BitNo)

Binary.BCLR_Long	EQU	0x4229	; Bit lschen, das durch BitNummer angegeben ist 	18.02.2007
					; in einem Longwert setzen				0$50
					; Binary.BCLR_Long(VarLong:Ziel,VarInt:BitNo)

Binary.BNOT_Long	EQU	0x422A	; Bit invertieren, das durch BitNummer angegeben ist	18.02.2007
					; in einem Longwert setzen				0$50
					; Binary.BNOT_Long(VarLong:Ziel,VarInt:BitNo)


Binary.AND_Long		EQU	0x4230	; AND zweier Long Q := A AND B		09.02.2007	0$50
					; Binary.AND_Long(VarLong:Q,VarLong:A,VarLong:B)

Binary.OR_Long		EQU	0x4231	; OR zweier Long  Q := A OR B		09.02.2007	0$50
					; Binary.OR_Long(VarLong:Q,VarLong:A,VarLong:B)

Binary.XOR_Long		EQU	0x4232	; XOR zweier Long Q := A XOR B		09.02.2007	0$50
					; Binary.XOR_Long(VarLong:Q,VarLong:A,VarLong:B)

Binary.NOT_Long		EQU	0x4238	; NOT zweier Long Q := NOT A		09.02.2007	0$50
					; Binary.NOT_Long(VarLong:Q,VarLong:A)

Binary.SWAP_WORD_Long	EQU	0x4239	; HighWord und LowWord tauschen		10.02.2006	0$50
					; Binary.SWAP_WORD_Long(VarLong:Q,VarLong:A)




; Farbbearbeitung  ---------------------------------------------------------------------------------------------
; Klasse eVM_Colors 


Colors.MoreRed_5Bit	EQU	0x3303	; vergrssert Rotanteil einer Farbe			29.08.2006
					; Colors.MoreRed_5Bit(VarInt)				eVM_Version_0$35				

Colors.MoreGreen_5Bit	EQU	0x3304	; vergrssert Grnanteil einer Farbe			29.08.2006
					; Colors.MoreGreen_5Bit(VarInt)				eVM_Version_0$35

Colors.MoreBlue_5Bit	EQU	0x3305	; vergrssert Blauanteil einer Farbe			29.08.2006
					; Colors.MoreBlue_5Bit(VarInt)				eVM_Version_0$35

Colors.MoreRedLimit_5Bit EQU	0x3306	; vergrssert Rotanteil einer Farbe mit Limit bei Max	29.08.2006
					; Colors.MoreRedLimit_5Bit(VarInt)			eVM_Version_0$35

Colors.MoreGreenLimit_5Bit EQU	0x3307	; vergrssert Grnanteil einer Farbe mit Limit bei Max	29.08.2006
					; Colors.MoreGreenLimit_5Bit(VarInt)			eVM_Version_0$35

Colors.MoreBlueLimit_5Bit EQU	0x3308	; vergrssert Blauanteil einer Farbe mit Limit bei Max	29.08.2006
					; Colors.MoreBlueLimit_5Bit(VarInt)			eVM_Version_0$35

Colors.LessRed_5Bit	EQU	0x3309	; vermindert Rotanteil einer Farbe			29.08.2006
					; Colors.LessRed_5Bit(VarInt)				eVM_Version_0$35

Colors.LessGreen_5Bit	EQU	0x330A	; vermindert Grnanteil einer Farbe			29.08.2006
					; Colors.LessGreen_5Bit(VarInt)				eVM_Version_0$35

Colors.LessBlue_5Bit	EQU	0x330B	; vermindert Blauanteil einer Farbe			29.08.2006
					; Colors.LessBlue_5Bit(VarInt)				eVM_Version_0$35

Colors.LessRedLimit_5Bit EQU	0x330C	; vermindert Rotanteil einer Farbe mit Limit bei Min	29.08.2006
					; Colors.LessRedLimit_5Bit(VarInt)			eVM_Version_0$35

Colors.LessGreenLimit_5Bit EQU	0x330D	; vermindert Grnanteil einer Farbe mit Limit bei Min	29.08.2006
					; Colors.LessGreenLimit_5Bit(VarInt)			eVM_Version_0$35

Colors.LessBlueLimit_5Bit EQU	0x330E	; vermindert Blauanteil einer Farbe mit Limit bei Min	29.08.2006
					; Colors.LessBlueLimit_5Bit(VarInt)			eVM_Version_0$35


Colors.BlackWhite	EQU	0x3310	; setzt die Farbe in Quelle in schwarz oder weiss um
					; Colors.BlackWhite(VarInt:Ziel,VarInt:Quelle)

Colors.AutoColor	EQU	0x3311	; ldt ZielVariabnle mit Kontrastfarbe schwarz oder weiss, je nach Quelle 
					; Colors.AutoColor(VarInt:Ziel,VarInt:Quelle)		12.06.2006


Colors.Load_RGB		EQU	0x3312	; Farbe mit RGB-Wert laden				19.07.2006
					; Colors.Load_RGB(VarInt:Ziel,VarInt:R,VarInt:G,VarInt:B)
					; Colors.Load_RGB(EI_FillColor,128,0,255)		eVM_Version_0$35

Colors.Darken		EQU	0x3313	; ldt ZielVariable mit abgedunkelter Farbe von Quelle(Ziel,Quelle)
					; Colors.Darken(VarInt:Ziel,VarInt:Quelle)		16.07.2006
					;							eVM_Version_0$35

Colors.Brighten		EQU	0x3314	; ldt ZielVariable mit abgedunkelter Farbe von Quelle(Ziel,Quelle)
					; Colors.Brighten(VarInt:Ziel,VarInt:Quelle)		16.07.2006
					;							eVM_Version_0$35


Colors.InverseColor	EQU	0x3315	; ldt ZielVariable mit der inversen Farbe von Quelle(Ziel,Quelle)
					; Colors.InverseColor(VarInt:Ziel,VarInt:Quelle)	18.07.2006



Colors.GetPixelColor	EQU	0x3316	; ldt ZielVariable mit der Farbe am Punkt(X/Y)		24.08.2006
					; Colors.GetPixelColor(VarInt:Ziel,VarInt:X,VarInt:Y)	eVM_Version_0$35




Colors.GetRed_5Bit	EQU	0x3317	; ldt ZielVariable mit 5-Bit Rotanteil der Farbe in QuellVariable 2.8.2006
					; Colors.GetRed_5Bit(VarInt:Ziel,VarInt:Color)
Colors.GetGreen_5Bit	EQU	0x3318	; ldt ZielVariable mit 5-Bit Grnanteil der Farbe in QuellVariable 2.8.2006
					; Colors.GetGreen_5Bit(VarInt:Ziel,VarInt:Color)
Colors.GetBlue_5Bit	EQU	0x3319	; ldt ZielVariable mit 5-Bit Blauanteil der Farbe in QuellVariable 2.8.2006
					; Colors.GetGreen_5Bit(VarInt:Ziel,VarInt:Color)(VarInt:Ziel,VarInt:Color)



Colors.GreyValue_5Bit	EQU	0x331A	; ermittelt Grauton zu Farbe					2.8.2006
					; Colors.GrayValue_5Bit(VarInt:Ziel,VarInt:Color)


Colors.ColorMix_5Bit	EQU	0x331B	; 2 Farben werden gemischt					3.8.2006
					; Colors.ColorMix_5Bit(VarInt:Ziel,VarInt:Color,VarInt:Color)


Colors.ColorMix_3to1_5Bit EQU	0x331C	; 2 Farben werden im Verhltnis 3:1 gemischt			3.8.2006
					; Colors.ColorMix(VarInt:Ziel,VarInt:Color 3 Teile, VarInt:Color: 1 Teil)



Colors.Cvt_ColorComp_5to8 EQU	0x331D	; 5-Bit Farbanteil in 8-Bit Farbanteil umwandeln	
					; Colors.Cvt_ColorComp_5to8(VarInt:8BitColor,VarInt:5BitColor)



Colors.Cvt_ColorComp_8to5 EQU	0x331E	; 8-Bit Farbanteil in 5-Bit Farbanteil umwandeln
					; Colors.Cvt_ColorComp_8to5(VarInt:5BitColor,VarInt:8BitColor)


Colors.PutRed_5Bit	EQU	0x331F	; speichert den Rotanteil in der QuellVariablen (0..31) in der ZielVariable 18.6.2008
					; Colors.PutRed_5Bit(VarInt:Color,VarInt:Quelle)

Colors.PutGreen_5Bit	EQU	0x3320	; speichert den Grnanteil in der QuellVariablen (0..31)in der ZielVariable 18.6.2008
					; Colors.PutGreen_5Bit(VarInt:Color,VarInt:Quelle)

Colors.PutBlue_5Bit	EQU	0x3321	; speichert den Blauanteil in der QuellVariablen (0..31) in der ZielVariable 18.6.2008
					; Colors.PutBlue_5Bit(VarInt:Color,VarInt:Quelle)(VarInt:Ziel,VarInt:Color)


Colors.Swap_Red_Green	EQU	0x3322	; vertauscht den roten und den grnen Farbanteil einer Farbe   21.6.2008
					; Colors.Swap_Red_Green(VarInt:ZielColor5B,VarInt:QuelleColor5B)

Colors.Swap_Green_Blue	EQU	0x3323	; vertauscht den grnen und den blauen Farbanteil einer Farbe  21.6.2008
					; Colors.Swap_Green_Blue(VarInt:ZielColor5B,VarInt:QuelleColor5B)

Colors.Swap_Blue_Red	EQU	0x3324	; vertauscht den blauen und den roten Farbanteil einer Farbe   21.6.2008
					; Colors.Swap_Blue_Red(VarInt:ZielColor5B,VarInt:QuelleColor5B)


Colors.SetColorPalette	EQU	0x3325	; 9er Farbpalette aus Ausgangsfarbe erstellen		       22.06.2008
					; Die Werte werden in eI.Palette_Color_X gespeichert
					; Colors.SetColorPalette(VarInt:QuelleColor5B)

Colors.SetGreyPalette	EQU	0x3326	; 9er Grauwertpalette aus Ausgangsfarbe erstellen	       22.06.2008
					; Die Werte werden in eI.Palette_Color_X gespeichert
					; Colors.SetGreyPalette(VarInt:QuelleColor5B)


Colors.SetMixPalettes	EQU	0x3327	; Die ColorPalette-Werte werden mit der Farbe gemixt           29.06.2008
					; und drei MixPaletten 25%, 50% und 75% erstellt
					; Colors.SetMixPalettes(VarInt:QuelleColor5B)



; Debuggingfunktionen  --------------------------------------------------------------------------------
; Klasse eVM_Debug
     

Debug.Mark		EQU	0x2323	; Debug.Mark zwei "Gartenhge" plus String in den Opcode einfgen
					; Debug.Mark(str)				

Debug.DumpBytes		EQU	0x2342	; DebugBytes Gartenhag-B Anzahl Bytes ausdumpen Debug.DumpBytes(Zahl)
					; Debug.DumpBytes(VarInt)

Debug.Print_String	EQU	0x2343	; String ber die Debug-Schnittstelle ausgeben		14.10.2006
					; Debug.Print_String(VarStr)				eVM_Version_0$45

Debug.Print_Char	EQU	0x2344	; Character ber die Debug-Schnittstelle ausgeben	29.10.2006
					; Debug.Print_Char(VarInt)				eVM_Version_0$45

Debug.Print_StringHeader EQU	0x2345	; StringHeaderdaten ber die Debug-Schnittstelle ausgeben 02.06.2007
					; Debug.Print_StringHeader(VarStr)			eVM_Version_0$45


Debug.Print_SingleHex	EQU	0x2347	; Single Hexadezimal ausgeben				19.11.2006 V0$45 
					; Debug.Print_SingleHex(str,VarSingle)

Debug.Print_LongHex	EQU	0x2348	; Long Hexadezimal ausgeben				18.11.2006 V0$45 
					; Debug.Print_LongHex(str,VarLong)

Debug.Print_IntegerHex	EQU	0x2349	; Debug.Print IntegerHex: Integer ausgeben		7.8.2006
					; Debug.Print_IntegerHex(str,VarInt)			eVM_Version_0$35
					; Debug.Print_IntegerHex('Zhler=',Counter)

Debug.Print_CRLF	EQU	0x234A	; Debug.Print_CRLF : Neue Zeile ausgeben		28.08.2006
					; Debug.Print_CRLF()					eVM_Version_0$35			


; Zeichenfunktionen  --------------------------------------------------------------------------------
; Klasse eVM_Draw


Draw.Line		EQU	0x4401	; Linie zeichnen, Parameter in Registern		26.08.2006		
					; Draw.Line()						Version_0$35

Draw.LineDown		EQU	0x4402	; Linie abwrts zeichnen, Parameter in Registern	26.08.2006
					; Draw.LineDown()					Version_0$35

Draw.LineUp		EQU	0x4404	; Linie aufwrts zeichnen, Parameter in Registern	26.08.2006
					; Draw.LineUp()						Version_0$35

Draw.LineLeft		EQU	0x4406	; Linie nach links zeichnen, Parameter in Registern	26.08.2006
					; Draw.LineLeft()					Version_0$35

Draw.LineRight		EQU	0x4408	; Linie nach rechts zeichnen, Parameter in Registern	26.08.2006
					; Draw.LineRight()					Version_0$35

Draw.Rectangle		EQU	0x440A	; Rechteck zeichnen, Parameter in Registern		26.08.2006
					; Draw.Rectangle()					Version_0$35 

Draw.RectangleFilled	EQU	0x440B	; geflltes Rechteck zeichnen, Parameter in Registern	26.08.2006
					; Draw.RectangleFilled()				Version_0$35 

Draw.Circle		EQU	0x440C	; Kreis zeichnen, Parameter in Registern		26.08.2006
					; Draw.Circle()						Version_0$35 

Draw.CircleFilled	EQU	0x440D	; gefllter Kreis zeichnen, Parameter in Registern	26.08.2006
					; Draw.CircleFilled()					Version_0$35 

Draw.Ellipse		EQU	0x440E	; Ellipse zeichnen, Parameter in Registern		26.08.2006
					; Draw.Ellipse()					Version_0$35 

Draw.EllipseFilled	EQU	0x440F	; gefllte Ellipse zeichnen, Parameter in Registern	26.08.2006
					; Draw.EllipseFilled()					Version_0$35 

Draw.Mark1Square	EQU	0x4411	; Punkt Koordinaten X1/Y1 auszeichnen quadratisch	26.08.2006
					; Draw.Mark1Square()					Version_0$35 

Draw.Mark1Round		EQU	0x4412	; Punkt Koordinaten X1/Y1auszeichnen rund		26.08.2006
					; Draw.Mark1Round()					Version_0$35 


Draw.Mark2Square	EQU	0x4413	; Punkt Koordinaten X2/Y2 auszeichnen quadratisch	26.08.2006
					; Draw.Mark2Square()					Version_0$35 


Draw.Mark2Round		EQU	0x4414	; Punkt Koordinaten X2/Y2 auszeichnen rund		26.08.2006
					; Draw.Mark2Round()					Version_0$35 


Draw.Icon		EQU	0x4415	; Icon zeichnen, EI_IconNumber ist InputParameter
;Draw.IconNumber	EQU	0x4416	; Icon mit Parameter zeichnen 
;Draw.SymbolNumber	EQU	0x4417	; Symbol zeichnen
Draw.Symbol_Imm		EQU	0x4417	; Symbol zeichnen
Draw.Symbol		EQU	0x4418	; Symbol zeichnen EI_SymbolNumber als Parameter
Draw.Border		EQU	0x4419	; DrawBorder Rahmen zeichnen implicit
*Draw.Border_Imm	EQU	0x441A	; DrawBorder Rahmen zeichnen immediate
Draw.SeparatorLine	EQU	0x441B	; Separator-Linie zeichnen
;Draw.Symbol_Imm_DeltaUL EQU	0x441C	; Symbol zeichnen EI_SymbolNumber als Parameter und Delta X und Delta Y
					; von der linken oberen Ecke (alt)
Draw.Symbol_DeltaUL	EQU	0x441D	; Symbol zeichnen EI_SymbolNumber als Parameter und Delta X und Delta Y
					; von der linken oberen Ecke (neu 27.05.2006)
					; Draw.Symbol_DeltaUL(Symbol32A_Home_1,14,4)		; HomeSymbol mit Delta 14/4

Draw.SymbolNumber	EQU	0x441E	; Symbol zeichnen, Variable als Parameter		5.8.2006		
					; Draw.SymbolNumber(VarInt:Symbol)
Draw.IconNumber		EQU	0x441F	; Icon zeichnen,Variable als Parameter			5.8.2006
					; Draw.IconNumber(VarInt:Icon)

Draw.BorderNumber	EQU	0x4420	; Rahmen zeichnen mit VarInt als Input			6.8.2006
					; Draw.BorderNumber(VarInt:BorderStyle)

Draw.Pixel		EQU	0x4421	; Pixel zeichnen					23.08.2006
					; Draw.Pixel()						Version_0$35

Draw.LineUpLength	EQU	0x4422	; Linie aufwrts zeichnen, Lnge als Parameter		26.08.2006
					; Draw.LineUpLength(VarInt)				Version_0$35

Draw.LineDownLength	EQU	0x4423	; Linie abwrts zeichnen, Lnge als Parameter		27.08.2006
					; Draw.LineDownLength(VarInt)				Version_0$35

Draw.LineLeftLength	EQU	0x4424	; Linie nach links zeichnen, Lnge als Parameter	27.08.2006
					; Draw.LineLeftLength(VarInt)				Version_0$35

Draw.LineRightLength	EQU	0x4425	; Linie nach rechts zeichnen, Lnge als Parameter	27.08.2006
					; Draw.LineLeftLength(VarInt)				Version_0$35

Draw.PixelColor		EQU	0x4426	; Pixel zeichnen, Farbe als Parameter			27.08.2006
					; Draw.PixelColor(VarInt)				Version_0$35 


Draw.ColorVector_Right	EQU	0x4427	; ColorVector zeichnen	rechts				27.10.2006 V0$45
					; Draw.ColorVector_Right(labelRelative24:ColorVector)


Draw.ColorVector_Up	EQU	0x4428	; ColorVector (Rechteck mit Farbverlauf) zeichnen	27.10.2006 V0$45
					; Draw.ColorVector_Up(labelRelative24:ColorVector)

Draw.ColorVector_Down	EQU	0x4429	; ColorVector zeichnen	(Rechteck mit Farbverlauf) zeichnen 28.10.2006 V0$45
					; Draw.ColorVector_Down(labelRelative24:ColorVector)


Draw.Char		EQU	0x442A	; Character zeichnen, eI.Pos_X1 und eI.Pos_Y1
					; werden um Characterbreite erhht
					; Draw.Char(VarInt:Character)				02.09.2008 V0$70

Draw.RectangleFilledRound EQU	0x442B	; Rechteck mit abgerundeten Ecken zeichnen 		02.01.2009 V0$80
					; Draw.RectangleFilledRound(VarInt:RoundCorner)


; Filefunktionen  -----------------------------------------------------------------------------------------
; Klasse eVM_File


File.Read_EGI		EQU	0x4604	; EGI-File von CFC in Videospeicher bringen
					; File.Read_EGI(C:\TG12\KIRSCHEN.EGI)
					; File.Read_EGI(VarStr:FileName)

*File.Read_EGI_Old	EQU	0x4605	; EGI-File von CFC in Videospeicher bringen(alte Version mit str)
*File.Read_EGI_Index3	EQU	0x4606	; EGI-File von CFC in Videospeicher bringen. Der Filename wird durch einen 3stelligen
					; Index modifiziert.
*File.Read_EGI_Index2	EQU	0x4607	; EGI-File von CFC in Videospeicher bringen. Der Filename wird durch einen 2stelligen
					; Index modifiziert.
;File.ScreenDump	EQU	0x4608	; ScreenDump schreiben
File.Read_CSV		EQU	0x4609	; CSV-File einlesen und in EVI-Speicher bringen  
					; OP-CODE,VarStr,VarStr File.Read_CSV(FileName,FileBuffer)


File.ScreenDump		EQU	0x460A	; ScreenDump schreiben					19.10.2006 V0$45
					; File.ScreenDump(VarStr)

File.DeleteFile		EQU	0x460B	; File lschen						30.10.2006 V0$45
					; File.DeleteFile(VarStr:FileName)


File.Write_TextFile	EQU	0x460C	; TextFile (String) auf CFC schreiben. 			18.10.2006  V0$45				
					; File.Write_TextFile(VarStr:FileName,VarStr:Buffer)


File.Read_TextFile	EQU	0x460D	; TextFile (String) von CFC in Buffer lesen. 		18.10.2006  V0$45				
					; File.Read_TextFile(VarStr:FileName,VarStr:Buffer)


File.FileSize		EQU	0x460E	; FileSize eines Files zurckliefern	 		14.02.2008  V0$60	

File.FileExists		EQU	0x460F	; Liefert zurck, ob ein File exisiert	 		14.02.2008  V0$60	

					
CSV.GetFieldData	EQU	0x4610	; DatenString aus CSV holen (ZielString,CSV_FileBuffer,CSV_Column,CSV_Line)
					; CSV.GetFieldData(VarStr:OutputString,VarStr:CSV_String,VarInt:Spalte,VarInt:Zeile)


File.AppendString	EQU	0x4611	; String an File anhngen				 4.8.2006
					; File.AppendString(VarStr:FileName,VarStr:String)


CSV.GetMax_Columns	EQU	0x4612	; Maximale Anzahl Spalten in einem CSV-File holen	26.09.2006  V0$40
					; CSV.GetMax_Columns(VarInt:MaxColumns,VarStr:CSV_String)

CSV.GetMax_Lines	EQU	0x4613	; Maximale Anzahl Zeilen in einem CSV-File holen	26.09.2006  V0$40
					; CSV.GetMax_Lines(VarInt:MaxLines,VarStr:CSV_String)

CSV.Find_in_Column	EQU	0x4614	; MatchString ab Zeile in Spalte in CSV-File suchen und ZeilenNummer und Daten
					; zeile zurckliefern
					; CSV.Find_in_Column(VarStr:CSV_String,VarInt:StartLine,VarInt:Colum,VarStr:MatchString,VarInt:LineNoFound,VarStr:DataLine)

CSV.Analyze_String	EQU	0x4615	; String als CSV-String analysieren			02.06.2007  V0$50
					; CSV.Analyze_String(VarStr:CSV_String)

CSV.Get_Integer		EQU	0x4616	; ganzzahlige Integerzahl einlesen			03.06.2007  V0$50 
					; CSV.Get_Integer(VarInt:Number,VarStr:InputString,VarInt:Spalte,VarInt:Zeile)

CSV.Get_UInteger	EQU	0x4617	; ganzzahlige unsigned Integerzahl einlesen		03.06.2007  V0$50 
					; CSV.Get_UInteger(VarInt:Number,VarStr:InputString,VarInt:Spalte,VarInt:Zeile)

CSV.Get_Long		EQU	0x4618	; ganzzahlige Longzahl einlesen				03.06.2007  V0$50 
					; CSV.Get_Long(VarLong:Number,VarStr:InputString,VarInt:Zeile,VarInt:Spalte)

CSV.Get_LongDeci	EQU	0x4619	; Dezimalzahl als Longzahl einlesen			03.06.2007  V0$50 
					; CSV.Get_LongDeci(VarLong:Number,VarStr:InputString,VarInt:Zeile,VarInt:Spalte,VarInt:Nachkomma)

CSV.Get_HighColor	EQU	0x461A	; Farbwert in WEB-Darstellung einlesen #0066FF		05.06.2007  V0$50 
					; CSV.Get_HighColor(VarInt:Color,VarStr:InputString,VarInt:Zeile,VarInt:Spalte)


CSV.Get_ByteHex		EQU	0x461B	; CSV.Get_ByteHex					06.06.2007  V0$50
					; CSV.Get_ByteHex(VarInt:Number,VarStr:InputString,VarInt:Zeile,VarInt:Spalte)
					; eI.Status error, falls Fehler	
					; eI.ErrorCode: 
					; WARINS.STRING_NotInHex	kein HEX-Zeichen wo erwartet
					; ERRINS.STRING_OutOfString	Position zeigt ausserhalb String
					; WARINS.STRING_EmptyString	leerer String


CSV.Get_WordHex		EQU	0x461C	; CSV.Get_WordHex					06.06.2007  V0$50
					; CSV.Get_WordHex(VarInt:Number,VarStr:CSV-String,VarInt:Zeile,VarInt:Spalte)
					; eI.Status [error  success]	
					; eI.ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]

CSV.Get_LongHex		EQU	0x461D	; CSV.Get_LongHex					06.06.2007  V0$50
					; CSV.Get_LongHex(VarLong:Number,VarStr:CSV-String,VarInt:Zeile,VarInt:Spalte)
					; eI.Status [error  success]	
					; eI.ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]


CSV.Get_String		EQU	0x461E	; CSV.Get_String					06.06.2007  V0$50
					; CSV.Get_String(VarStr:String,VarStr:CSV-String,VarInt:Zeile,VarInt:Spalte)
					; eI.Status [error  success]	
					; eI.ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]

CSV.Put_String		EQU	0x461F	; CSV.Put_String					08.09.2007  V0$55
					; CSV.Put_String(VarStr:String,VarStr:CSV-String,VarInt:Zeile,VarInt:Spalte)
					; eI.Status [error  success]	
					; eI.ErrorCode [NoError  eVM_EmptyString_Error  eVM_OutOfString_Error
					; eVM_NotInHex_Error]
					; 


CSV.DataFieldLength	EQU	0x4620	; CSV.DataFieldLength					08.09.2007 V0$55
					; Lnge eines DataFields bestimmen
					; CSV.DataFieldLength(VarInt:Length,VarStr:CSV-String,VarInt:Zeile,VarInt:Spalte)

File.OpenRead		EQU	0x4630	; File fr Lesezugriff ffnen
					; File.OpenRead(VarInt:Handle.I,VarStr:FileName)
					; eI.Status [error  success]
File.OpenWrite		EQU	0x4631	; File fr Schreibzugriff ffnen
					; File.OpenWrite(VarInt:Handle.I,VarStr:FileName)
					; eI.Status [error  success]
File.OpenAppendWrite	EQU	0x4632	; File fr Schreibzugrigg Anhngen ffnen
					; File.OpenAppendWrite(VarInt:Handle.I,VarStr:FileName)
					; eI.Status [error  success]
File.Close		EQU	0x4633	; File schliessen
					; File.Close(VarInt:Handle.I)
File.Read_ToBuffer	EQU	0x4634	; Daten aus File auslesen
					; File.Read_ToBuffer(Handle.I,VarStr:Buffer,VarLong:Offset,VarLong:NumBytes,VarLong:BytesRead)



;HotSpot.DeInstall	EQU	0x4800	; HotSpot deinstallieren
;HotSpot.Install_OLD	EQU	0x4801	; HotSpot installieren
HotSpot.DeInstallGroup	EQU	0x4802	; HotSpot-Gruppe deinstallieren
HotSpot.GetNextGroupNumber EQU	0x4803	; HotSpot nchste Gruppennummer holen. Adressierungsart implicit.
HotSpot.GetCurrGroupNumber EQU	0x4804	; HotSpot aktuelle Gruppennummer holen. Adressierungsart implicit.
HotSpot.DeInstall	EQU	0x4805	; HotSpot deinstallieren
HotSpot.TableEnable	EQU	0x4808	; HotSpot Tabelle freigeben
HotSpot.TableDisable	EQU	0x4809	; HotSpot Tabelle sperren
HotSpot.TableDestroy	EQU	0x480A	; HotSpot Tabelle abrumen
HotSpot.Install_ABS	EQU	0x480B	; HotSpot installieren
HotSpot.Install		EQU	0x480C	; HotSpot installieren 15.06.2006 mit 24-bit relativen Pointern

HotSpot.DisableRegion	EQU	0x480D	; HotSpots in einer Region sperren			03.03.2007 V0$50
					; eI.Pos_X1, eI.Pos_Y1, eI.Offset_X,eI_Offset_Y
					; und eI.Width und eI.Height werden als Input Parameter gebraucht.
												

HotSpot.EnableRegion	EQU	0x480E	; HotSpots in einer Region freigeben			03.03.2007 V0$50
					; eI.Pos_X1, eI.Pos_Y1, eI.Offset_X,eI_Offset_Y
					; und eI.Width und eI.Height werden als Input Parameter gebraucht.
												
HotSpot.Disable_BaseGroup  EQU	0x480F	; sperrt die BaseGroup von 0x00 bis 0x0F		04.03.2007 V0$50


HotSpot.Enable_BaseGroup   EQU	0x4810	; gibt die BaseGroup von 0x00 bis 0x0F wieder frei	04.03.2007 V0$50

HotSpot.Disable_By_ID	EQU	0x4811	; gibt den HotSpot mit ID xxx frei 20.12.2008
					; HotSpot.Disable_By_ID (VarInt:HotSpot_ID)

HotSpot.Enable_By_ID	EQU	0x4812	; sperrt den HotSpot mit ID xxx 20.12.2008
					; HotSpot.Enable_By_ID (VarInt:HotSpot_ID)

HotSpot.DisableGroup	EQU	0x4813	; gibt die HotSpot Gruppe xxx frei 20.12.2008
					; HotSpot.DisableGroup ( VarInt: Group )

HotSpot.EnableGroup	EQU	0x4814	; gibt die HotSpot Gruppe xxx frei 20.12.2008
					; HotSpot.EnableGroup ( VarInt: Group )

HotSpot.GetInfo_By_ID	EQU	0x4815	; holt HotSpot Info aus der Tabelle 21.12.2008
					; HotSpot.GetInfo_By_ID (VarInt:HotSpot_ID)


;HotKeyInputSelect	EQU	0x002E	; whlt den HotKey Input aus

;HotKey.DeInstall	EQU	0x4B00	; HotKey deinstallieren (obsolete) (b)
*HotKey.Install		EQU	0x4B01 	; HotKey installieren (obsolete) (b,procname)
;HotKey.InstallMulti	EQU	0x4B02	; mehrere HotKeys installieren
HotKey.InputFlush	EQU	0x4B03	; HotKey Input (Keyboard-Schnittstelle) lschen
HotKey.InputSelect	EQU	0x4B04	; whlt den HotKey Input aus	

HotKey.DeInstallKey	EQU	0x4B05	; HotKey deinstallieren
					; HotKey.DeInstallKey(VarInt:Char)		28.09.2006	V0$40

HotKey.DisableLocalKeys	EQU	0x4B06	; lokale HotKeys sperren			29.09.2006	V0$40
					; HotKey.DisableLocalKeys()

HotKey.EnableLocalKeys	EQU	0x4B07	; lokale HotKeys freigeben			29.09.2006	V0$40
					; HotKey.EnableLocalKeys()

HotKey.TableEnable	EQU	0x4B08	; HotKey Tabelle anstellen (KeyEvents auswerten)
					; HotKey.TableEnable()				29.09.2006	V0$40

HotKey.TableDisable	EQU	0x4B09	; HotKey Tabelle abstellen (KeyEvents sperren)
					; HotKey.TableDisable()				29.09.2006	V0$40

HotKey.TableInit	EQU	0x4B0A	; HotKey Table initialisieren (abrumen) und disablen
					; HotKey.TableInit()				29.09.2006	V0$40


HotKey.InstallLocalKey	EQU	0x4B0B	; HotKey installieren				25.09.2006	V0$40
					; HotKey.InstallLocal(VarInt:Char,labelRelative24:Event,VarInt:Tag)



;HotChar.Install	EQU	0x4B21	; HotChar installieren (COM1,"A",HC_Character_A_Event)


; Schreibfunktionen  -----------------------------------------------------------------------------------------
; Klasse eVM_Label


Label.Text		EQU	0x4C04	; Text darstellen ber Pointer auf nullterminierten String 24-Bit Pointer	
;Label.TextPtr		EQU	0x4C05	; Text darstellen ber Pointer auf nullterminierten String (obsolete Schreibweise 32 bit)
;Label.Text_Ptr		EQU	0x4C05	; Text darstellen ber Pointer auf nullterminierten String
;Label.Text_Imm		EQU	0x4C06	; Text darstellen, der auf den OP_Code folgt (nullterminierter String)
*Label.Text_TextPointer	EQU	0x4C07	; Text darstellen, der ber den EI_TextPointer adressiert wird. 
Label.SetFont		EQU	0x4C03	; Font mit einem 24-Bit-Pointer auf eingebetteten Font auswhlen
Label.Color		EQU	0x4C02	; Label frben: eI.FillColor,eI.BackColor und eI.LineColor werden
					; mit der angegebenen Farbe geladen. Die Farbe von eI.TextColor wird
					; mit autocolor bestimmt. Wenn die Farbe transparent ist, wird eI.DisplayColor
					; zur Bestimmung der Farbe von eI.TextColor herangezogen.
					; Label.Color(VarInt)					; 26.07.2006

Label.GreyColor		EQU	0x4C08	; Label.GreyColor weist den eI.TextColor, eI.FillColor,eI.LineColor und
					; eI.BackColor den jeweiligen Grauwert der Farbe zu. Kann gebraucht werden
					; um ein Label als deaktiviert zu kennzeichnen
					; Label.GreyColor()					; 23.03.2007 V0$50

Label.PrintString	EQU	0x4C09	; Text darstellen ber Pointer auf nullterminierten String 24-Bit Pointer
					; ohne die Box zu zeichnen
					; Label.PrintString(VarStr:String)		
					; 							; 24.03.2007 V0$50

Label.Box		EQU	0x4C0A	; Zeichnet mit den eingestellten Parametern eine Box ohne einen String zu
					; schreiben
					; Label.Box()

Label.StringWidth	EQU	0x4C0B	; Bestimmt die Breite in Pixel eines Strings mit dem eingestellten Font
					; Label.StringWidth(VarInt:Width,VarStr:String)
					; 							; 24.03.2007 V0$50

Label.Font_Init		EQU	0x4C0C	; Initialiseirt einen Font				; 25.03.2007 V0$50
					; IPARM eI.FontNumber
					; in eI.LabelFont_... stehen die Fontparameter
					; Label.Font_Init()

; Lade/Fll/Transferfunktionen  -----------------------------------------------------------------------------------------
; Klasse eVM_Load
					; Q-------
;Load.LabelParameter_Ptr_Old	EQU	0x5101	; Load Label Parameter alle Paramter werden geladen
;Load.LabelParameter_Ptr	EQU	0x5102	; Load Label Parameter alle Paramter werden geladen  23.07.2006
					; Load.LabelParameter_Ptr(labelRelative24)	

Fill.LabelParameter	EQU	0x5102	; Fill Label Parameter alle Paramter werden geladen  28.07.2006
					; Fill.LabelParameter(labelRelative24)


Transfer.HotSpotGeometry EQU	0x5120	; HotSpot Geometrie nach Event in eI.Width etc. bertragen  28.07.2006
					; Transfer.HotSpotGeometry() spart 6 Zuweisungen. 

Transfer.HotSpotOffset	EQU	0x5121	; HotSpot Offset nach Event in eI.Offset_X und eI.Offset_Y bertragen  28.07.2006
					; Transfer.HotSpotOffset() spart 2 Zuweisungen. 

Transfer.Offset_from_Pos_X1Y1 EQU 0x5122 ; Ldt eI.Offset_X := eI.Pos_X1,  eI.Offset_Y := eI.Pos_Y1
					; Transfer.Offset_from_Pos_X1Y1 ()		17.09.2006  V0$40

Transfer.To_HotSpotInfo	EQU	0x5123	; Installationshilfe, ldt die eI.HS...-Register
					; aus der Geometrie etc, so dass lageunabhngige
					; Controls beim Installieren von HotSpots die
					; LEAVE-Funktion bentzen knnen.		09.07.2008 V0$70

Transfer.Single_To_Long	EQU	0x5124	; Single in Long transferieren (Zahlenananalyse) 08.12.2008			
					; Transfer.Single_To_Long(VarSingle:Single,VarLong:Long)


Transfer.Long_To_Single	EQU	0x5125	; Long in Single transferieren (Zahlenanalyse)	08.12.2008
					; Transfer.Long_To_Single(VarLong:Long,VarSingle:Single)


Load.Enlarge		EQU	0x513E	; Rechteck vergrsseren ( plus) oder verkleinern ( minus ) 03.01.2009
					; Load.Enlarge(VarInt:Number)

Load.ColorScheme	EQU	0x513F	; ColorSchema laden				14.06.2008 V0$60	
					; Load.ColorScheme ( VarInt:ColorScheme_Number )

Load.Pos_X1Y1		EQU	0x5140	; Ldt die Register eI.Pos_X1 und eI.Pos_Y1		06.08.2006
					; Load.Pos_X1Y1(VarInt:X1,VarInt:Y1)

Load.Pos_X2Y2		EQU	0x5141	; Ldt die Register eI.Pos_X2 und eI.Pos_Y2		06.08.2006
					; Load.Pos_X1Y1(VarInt:X1,VarInt:Y1)

Load.Width_Height	EQU	0x5142	; Ldt die Register eI.Width und eI.Height		06.08.2006
					; Load.Width_Height(VarInt:W,VarInt:H)

Load.Geometry_XYWH	EQU	0x5143	; Ldt die Register eI.Pos_X1,eI.Pos_Y1,eI.Width,eI.Height  06.08.2006
					; Load.Geometry_XYWH(VarInt:X1,VarInt:Y1,VarInt:W,VarInt:H)

Load.Offset_XY		EQU	0x5144	; Ldt die Offset-Register eI.Offset_X und eI.Offset_Y
					; Load.Offset_XY(VarInt:X,VarInt:Y)

Load.Color_FL		EQU	0x5145	; Ldt die Register eI.FillColor und eI.LineColor
					; Load.Color_FL(VarInt:FillColor,VarInt:LineColor)

Load.Color_BT		EQU	0x5146	; Ldt die Register eI.BackColor und eI.TextColor
					; Load.Color_BT(VarInt:BackColor,VarInt:TextColor)

Load.Data_from_ARRAY_Integer EQU 0x5147 ; Lesezugriff auf Integer-ARRAY (Konstantentabelle)	29.10.2006 Version_0$45
					; Load.Data_from_ARRAY_Integer(labelRelative24,VarInt:Index,VarInt:Ziel)

Store.Data_to_ARRAY_Integer EQU	0x5148	; Schreibzugriff auf Integer-ARRAY			29.10.2006 Version 0$45
					; Store.Data_to_ARRAY_Integer(labelRelative24,VarInt:Index,VarInt:Wert)


Load.CallBackAddress	EQU	0x5149	; Absolute Adresse bilden und zurckliefern		12.11.2006 Version 0.45
					; Load.CallBackAddress(VarLong:CallBackAddress,labelRelative24:SubroutineAddress)

Load.Data_from_ARRAY_UByte  EQU 0x514A 	; Lesezugriff auf Byte-ARRAY (Konstantentabelle)	20.07.2007 Version_0$50
					; unsigned Byte lesen
					; Load.Data_from_ARRAY_UByte(labelRelative24,VarInt:Index,VarInt:Ziel)

Load.Data_from_ARRAY_SByte  EQU 0x514B 	; Lesezugriff auf Byte-ARRAY (Konstantentabelle)	20.07.2007 Version_0$50
					; signed Byte lesen
					; Load.Data_from_ARRAY_SByte(labelRelative24,VarInt:Index,VarInt:Ziel)

Store.Data_to_ARRAY_Byte  EQU	0x514C	; Schreibzugriff auf Byte-ARRAY				20.07.2007 Version 0$45
					; Store.Data_to_ARRAY_Byte(labelRelative24,VarInt:Index,VarInt:Wert)

Buffer.Get_INT8_I	EQU 0x5150	; Lesezugriff "INT8" auf Buffer 			15.01.2009 Version 0$80
					; Buffer.Get_INT8_I(VarInt:INT8,VarStr:Buffer,VarLong:Offset)

Buffer.Get_UINT8_I	EQU 0x5151	; Lesezugriff "UINT8" auf Buffer 
					; Buffer.Get_UINT8_I(VarInt:UINT8,VarStr:Buffer,VarLong:Offset)

Buffer.Get_INT16	EQU 0x5152	; Lesezugriff "INT16" auf Buffer 
					; Buffer.Get_INT16(VarInt:INT16,VarStr:Buffer,VarLong:Offset)

Buffer.Get_UINT16	EQU 0x5153	; Lesezugriff "UINT16" auf Buffer 
					; Buffer.Get_UINT16(VarInt:UINT16,VarStr:Buffer,VarLong:Offset)

Buffer.Get_INT32	EQU 0x5154	; Lesezugriff "INT32" auf Buffer 
					; Buffer.Get_INT32(VarLong:INT32,VarStr:Buffer,VarLong:Offset)

Buffer.Put_INT8_I	EQU 0x5155	; Schreibzugriff "INT8" auf Buffer 
					; Buffer.Put_INT8_I(VarInt:INT8,VarStr:Buffer,VarLong:Offset)

Buffer.Put_UINT8_I	EQU 0x5156	; Schreibzugriff "UINT8" auf Buffer 			21.01.2009 Version 0$80
					; Buffer.Put_UINT8_I(VarInt:UINT8,VarStr:Buffer,VarLong:Offset)

Buffer.Put_INT16	EQU 0x5157	; Schreibzugriff "INT16" auf Buffer 
					; Buffer.Put_INT16(VarInt:INT16,VarStr:Buffer,VarLong:Offset)

Buffer.Put_UINT16	EQU 0x5158	; Schreibzugriff "UINT16" auf Buffer 
					; Buffer.Put_UINT16(VarInt:UINT16,VarStr:Buffer,VarLong:Offset)

Buffer.Put_INT32	EQU 0x5159	; Schreibzugriff "INT32" auf Buffer 
					; Buffer.Put_INT32(VarLong:INT32,VarStr:Buffer,VarLong:Offset)





; Timerfunktionen  -----------------------------------------------------------------------------------------
; Klasse eVM_Timer

Timer.DeInstall_Old	EQU	0x5400	; Timer DeInstallieren
Timer.Install_Old	EQU	0x5401	; Timer Installieren
Timer.Load_Old		EQU	0x5402	; Timer laden
Timer.Get		EQU	0x5403	; Timer holen
Timer.StartSingle_Old	EQU	0x5404	; Timer StartSingle
Timer.StartContinuous_Old  EQU	0x5405	; Timer StartContinuous
Timer.Stop_Old		EQU	0x5406	; Timer Stop
Timer.Continue_Old	EQU	0x5407 	; Timer Continue	
Timer.TableEnable	EQU	0x5408	; Timer TableEnable
Timer.TableDisable	EQU	0x5409	; Timer TableDisable
Timer.TableDestroy_Old	EQU	0x540A	; Timer TableDestroy

Timer.Init		EQU	0x540A	; Timer initialisieren
					; Timer.Init()					01.10.2006 0$40

Timer.Load		EQU	0x540B	; Timer RELOAD-Register mit Zeit laden
					; Timer.Load(VarInt:Timer,VarInt:Zeit)		01.10.2006 0$40

Timer.InstallLocal	EQU	0x540C	; Timer installieren und enablen		01.10.2006 0$40
					; Timer.InstallLocal(VarInt:Timer, labelRelative24:Event)

Timer.StartSingle	EQU	0x540D	; Timer starten fr einen Zyklus		01.10.2006 0$40
					; Timer.StartSingle(VarInt:Timer)

Timer.StartContinuous	EQU	0x540E	; Timer starten fr kontinuierliche Zyklen	01.10.2006 0$40
					; Timer.StartContinuous(VarInt:Timer)

Timer.Stop		EQU	0x540F	; Timer anhalten				01.10.2006 0$40
					; Timer.Stop(VarInt:Timer)

Timer.Continue		EQU	0x5410	; Timer weiterlaufen lassen			01.10.2006 0$40
					; Timer.Continue(VarInt:Timer)

Timer.Get_TimerCounter	EQU	0x5411	; TimerCounter holen				02.10.2006 0$40
					; Timer.Get_TimerCounter(VarInt:Timer,VarInt:TimerCounter)

Timer.Get_ExpiredCounter  EQU	0x5412	; ExpiredCounter holen				02.10.2006 0$40
					; Timer.Get_ExpiredCounter(VarInt:Timer,VarInt:TimerCounter)

Timer.Reload		EQU	0x5413	; Timer nachladen RELOD --> MSCNT		03.10.2006 0$40
					; Timer.Reload(VarInt:Timer)

Timer.Load_ExpiredCounter  EQU	0x5414	; ExpiredCounter laden: Wert --> EXPCNT		04.10.2006 0$40
					; Timer.Load_ExpiredCounter(VarInt:Timer,VarInt:Wert)

Timer.SUB_ExpiredCounter  EQU	0x5415	; ExpiredCounter := ExpiredCounter - Wert	06.10.2006 0$40
					; Timer.SUB_ExpiredCounter(VarInt:Timer,VarInt:Wert)

Timer.DeInstall		EQU	0x5416	; Timer DeInstallieren				06.10.2006 0$40 
					; Timer.DeInstall(VarInt:Timer)


Timer.Kill		EQU	0x5417	; Timer Kill					22.11.2007 0$60 
					; Timer.Kill(VarInt:Timer)


Timer.InstallGlobal	EQU	0x5418	; Globalen Timer installieren			22.11.2007 0$60 
					; Timer.InstallGlobal(VarInt:Timer, labelAbsolute:Event)


; Time Klasse ----------------------------------------------------------------------------------

Time.Set		EQU	0x5420	; Zeit aus eI.MS etc. Registern laden (Uhr setzen)	14.10.2006
					; Time.Set()
; Folgende Register (ausser DOW) mssen geladen werden:							0$45
;	eI.MSEC				; MilliSekundenRegister [0..999]
;	eI.SEC				; SekundenRegister [0..59]
;	eI.MIN				; MinutenRegister  [0..59]
;	eI.HOURS			; StundenRegister  [0..23]
;	eI.DATE				; TagRegister	   [1..31]
;	eI.MONTH			; MonatsRegister   [1..12]
;	eI.YEAR				; Jahr Register    [2000..2100]
;	eI.DOW				; Day of Week	   [1..7]  1=Montag, 7=Sonntag


Time.Get		EQU	0x5421	; Zeit aus Uhr in eI.MS etc. Register holen	14.10.2006			
					; Time.Get()					0$45
					; Die interne Uhr wird ausgelesen und alle Zeit-Register
					; aktualisiert


Time.DayOfWeek		EQU	0x5422	; Die Methode liest die Datumsregister und liefert
					; den dazugehrigen Day of week zurck				



Time.SetTime		EQU	0x5423	; Zeit in die RTC schreiben
					; Time.SetTime()


Time.SetDate		EQU	0x5424	; Datum in die RTC schreiben
					; Time.SetDate()


Delay.WaitRegister()	EQU	0x5430	; holt die Wartezeit aus EI_Delay und wartet n ms
					; Delay.WaitRegister()


Delay.Wait_n_ms		EQU	0x5431	; n ms warten
					; Delay.Wait_n_ms(VarInt)

EVE.Init		EQU	0x5600	; initialisiert die eiger Video Engine
					; EVE.Init()
;EVE.Load_XSTART_Imm	EQU	0x5609	; XSTART-Register laden immediate
;EVE.Load_XSTART_Imp	EQU	0x560A	; XSTART-Register reloaden (EIFOX_XSTART--> EVE) implicit

EVE.Load_XSTART		EQU	0x5608	; XSTART-Register
					; EVE.Load_XSTART(VarInt)
;EVE.WriteTo_AVR	EQU	0x560B	; schreibt in AVR
;EVE.WriteTo_RVR	EQU	0x560C	; schreibt in RVR
;EVE.WriteTo_AVR_RVR	EQU	0x560D	; schreibt in AVR und RVR
EVE.WriteEnable_AVR	EQU	0x560B	; schreibt in AVR
EVE.WriteEnable_RVR	EQU	0x560C	; schreibt in RVR
EVE.WriteEnable_AVR_RVR	EQU	0x560D	; schreibt in AVR und RVR
EVE.Process_Transparence  EQU	0x560E	; Transparenz "abwehren" (Normalmodus)
EVE.Load_Transparence	EQU	0x560F	; Transparenz laden, damit die EVE sie nachher verarbeiten kann


;PUSH_ByteLowReg	EQU	0x5800	; Byte Low Pushen
;PUSH_ByteHighReg	EQU	0x5801	; Byte High Pushen
;PUSH_WordReg		EQU	0x5802	; Word Pushen
;PUSH_LongReg		EQU	0x5803	; Longword Pushen
	
;POP_ByteLowReg		EQU	0x5804	; Byte Popen
;POP_ByteHighReg	EQU	0x5805	; Byte Popen
;POP_WordReg		EQU	0x5806	; Word Popen
;POP_LongReg		EQU	0x5807	; Longword Popen

PUSH_Long		EQU	0x5803	; Longword pushen
					; PUSH_Long(VarLong)
POP_Long		EQU	0x5807	; Longword popen
					; POP_Long(VarLong)

PUSH_Word		EQU	0x580A	; Word Pushen					; 24.07.2006
					; PUSH_Word(VarInt:Quelle)
POP_Word		EQU	0x580E	; Word Popen					; 24.07.2006
					; eVM_System_POP_Word(VarInt:Ziel)

PUSH_Offset		EQU	0x5820	; EI_Offset_X und EI_Offset_Y pushen		; 26.07.2006
					; PUSH_Offset()
POP_Offset		EQU	0x5821	; EI_Offset_X und EI_Offset_Y popen		; 26.07.2006
					; POP_Offset()

System.Reset		EQU	0x580F	; System Reset ausfhren			; 17.11.2007
					; System.Reset () 

System.Reset_ms_Counter	EQU	0x580B	; ms_Counter resetten				; 21.08.2006
					; System.Reset_ms_Counter()

System.Get_ms_Counter	EQU	0x580C	; ms Counter holen
					; System.Get_ms_Counter(VarLong)

					; 21.08.2006 experimenelle Funktionen ----------------------------
Experimental.Reset_ms_Counter	EQU	0x580B	; ms_Counter resetten			; resetten
						; Experimental.Reset_ms_Counter()

Experimental.Get_ms_Counter	EQU	0x580C	; ms Counter holen
						; Experimental.Get_ms_Counter(VarLong)






Math.ADD_Long		EQU	0x4D20	; ADD Long   (Resultat,Operand1,Operand2) (VarLong,VarLong,VarLong) 17.06.2006
Math.SUB_Long		EQU	0x4D21	; SUB Long   (Resultat,Operand1,Operand2) (VarLong,VarLong,VarLong) 21.06.2006 Res:=Op1-Op2

Math.MUL_Long		EQU	0x4D22	; MUL Long   (Resultat,Operand1,Operand2) 	Version 0$45
					; Math.MUL_Long(VarLong,VarLong,VarLong) 	28.12.2006 Res:=Op1*Op2

Math.DIV_Long		EQU	0x4D23	; DIV Long   (Resultat,Operand1,Operand2) 	Version 0$45
					; Math.DIV_Long(VarLong,VarLong,VarLong) 	28.12.2006 Res:=Op1/Op2

Math.NEG_Long		EQU	0x4D24	; NEG Long Y:= -A				; 28.12.2006
					; Math.NEG_Long (VarLong:Y,VarLong:A)		; eVM_Version_0$45

Math.ABS_Long		EQU	0x4D25	; ABS Long Y:= A				; 28.12.2006
					; Math.ABS_Long (VarLong:Y,VarLong:A)		; eVM_Version_0$45



Math.INC_Long		EQU	0x4D28	; Math.INC_Long(VarLong)			 8.8.2006
Math.DEC_Long		EQU	0x4D29	; Math.DEC_Long(VarLong)			 8.8.2006


; nur zum testen der Adressierungsarten
Math.MOVE_LongImm	EQU	0x4D30	; Math.MOVE_LongImm(VarLong,i,b)	10.08.2006 wird wieder entfernt !!
Math.MOVE_LongPop	EQU	0x4D30	; Math.MOVE_LongPop(VarLong,i,b)	10.08.2006 wird wieder entfernt !!
Math.MOVE_LongPush	EQU	0x4D30	; Math.MOVE_LongPush(i,b,VarLong)	10.08.2006 wird wieder entfernt !!
; nur zum testen, ob die neue Adressierungsart 0xFB funktioniert 		10.08.2006 wird wieder entfernt !!
Math.MOVE_LongTest	EQU	0x4D30	; (VarLong,i,b)

Math.ADD_IntegerTest	EQU	0x2601	; (VarInt,VarInt,i,b)
Math.MULS_IntegerTest	EQU	0x2607	; (i,b,VarInt:Multiplikand,VarInt:Multiplikator)

Math.ADD_Single		EQU	0x4D40	; Single Addition	(Resultat,Operand1,Operand2)(VarSingle,VarSingle,VarSingle) 8.6.2006
Math.SUB_Single		EQU	0x4D41	; Single Subtraktion	(Resultat,Operand1,Operand2)(VarSingle,VarSingle,VarSingle) 8.6.2006
Math.DIV_Single		EQU	0x4D43	; Single Division	(Resultat,Operand1,Operand2)(VarSingle,VarSingle,VarSingle) 8.6.2006
Math.MUL_Single		EQU	0x4D47	; Single Multiplikation	(Resultat,Operand1,Operand2)(VarSingle,VarSingle,VarSingle) 8.6.2006



Math.SIN_Single		EQU	0x4D48	; Single SINUS				; 07.01.2007
					; Y := SIN(Winkel)			; eVM_Version_0$50
					; Math.SIN_Single(VarSingle:Y,VarSingle:Winkel_RAD)


Math.COS_Single		EQU	0x4D49	; Single COSINUS			; 08.01.2007
					; Y := COS(Winkel)			; eVM_Version_0$50
					; Math.COS_Single(VarSingle:Y,VarSingle:Winkel_RAD)


Math.LN_Single		EQU	0x4D4A	; Single LN natural Logarithm		; 08.01.2007
					; Y := LN(X)				; eVM_Version_0$50
					; Math.LN_Single(VarSingle:Y,VarSingle:X)

Math.TAN_Single		EQU	0x4D4B	; Single TANGENS			; 08.01.2007
					; Y := TAN(Winkel)			; eVM_Version_0$50
					; Math.TAN_Single(VarSingle:Y,VarSingle:Winkel_RAD)

Math.EXP_Single		EQU	0x4D4C	; Single e hoch x			; 08.01.2007
					; Y := EXP(X)				; eVM_Version_0$50
					; Math.EXP_Single(VarSingle:Y,VarSingle:X)

Math.SQR_Single		EQU	0x4D4D	; Single Quadratzahl			; 08.01.2007
					; Y := X^2				; eVM_Version_0$50
					; Math.SQR_Single(VarSingle:Y,VarSingle:X)

Math.SQRT_Single	EQU	0x4D4E	; Single Quadratwurzel			; 12.01.2007
					; Y := SQRT(X)				; eVM_Version_0$50
					; Math.SQRT_Single(VarSingle:Y,VarSingle:X)

Math.LOG_Single		EQU	0x4D4F	; Single LN natural Logarithm		; 14.01.2007
					; Y := LN(X)				; eVM_Version_0$50
					; Math.LN_Single(VarSingle:Y,VarSingle:X)

Math.MOVE_Single	EQU	0x4D50	; Single Verschieben
					; (Resultat,Operand) Math.MOVE_Single(MyReal8,Single_Null) 17.6.2006


Math.POWER_Single	EQU	0x4D51	; Single power x power y		; 20.01.2007
					; Math.POWER_Single(VarSingle:Result,VarSingle:x,VarSingle:exponent)



Math.CVT_Single_from_Integer 	EQU 0x4D80 ;(MyReal6,EI_Int_1)	; MyReal6 := CVT_Single_f_Integer(EI_Int_1)
Math.CVT_Single_from_UInteger	EQU 0x4D81 ; (MyReal6,EI_Int_1)	; MyReal6 := CVT_Single_f_UInteger(EI_Int_1)
Math.CVT_Long_from_Integer	EQU 0x4D82 ; (MyLong,MyInteger)	; MyLong := CVT_Long_f_Integer(MyInteger)
Math.CVT_Long_from_UInteger	EQU 0x4D83 ; (MyLong,MyInteger)	; MyLong := CVT_Long_f_UInteger(MyInteger)

Math.CVT_Long_from_Single	EQU 0x4D84 ; SingleZahl in Long umwandeln			18.11.2006 Version 0$45
					   ; Math.CVT_Long_from_Single(VarLong,VarSingle)


Math.CVT_LongDeci_from_Single	EQU 0x4D85 ; SingleZahl in LongDeci umwandeln			18.11.2006 Version 0$45
					   ; Math.CVT_LongDeci_from_Single(VarLong:Long,VarSingle:Single,VarInt:Dezimalstellen)

Math.CVT_UInteger_from_Long	EQU 0x4D86 ; Longzahl in UInteger umwandeln			19.11.2006 Version 0$45
					   ; Math.CVT_UInteger_from_Long(VarInt:Integer,VarLong:Long)

Math.CVT_Integer_from_Long	EQU 0x4D87 ; Longzahl in Integer umwandeln			19.11.2006 Version 0$45
					   ; Math.CVT_Integer_from_Long(VarInt:Integer,VarLong:Long)

Math.CVT_Single_from_Long	EQU 0x4D88 ; Longzahl in Single umwandeln			19.11.2006 Version 0$45
					   ; Math.CVT_Single_from_Long(VarSingle:Single,VarLong:Long)

Math.CVT_Single_from_LongDeci	EQU 0x4D89 ; LongDeziZahl in Single umwandeln			19.11.2006 Version 0$45
					   ; Math.CVT_Single_from_LongDeci(VarSingle:Single,VarLong:Long,VarInt:Dezimalstellen)


Math.CVT_Long_from_Single_Round	EQU 0x4D8A ; SingleZahl in Long umwandeln mit Rundung		07.01.2007 Version 0$50
					   ; Math.CVT_Long_from_Single_Round(VarLong,VarSingle)
	



Math.OR_Integer_MULTI	EQU	0x4DA0	; Multi-Input OR-Funktion			7.8.2006
					; Math.OR_Integer_MULTI(VarInt:Q,i:n,VarInt:1...VarInt:n)

Math.AND_Integer_MULTI	EQU	0x4DA1	; Multi-Input AND-Funktion			7.8.2006
					; Math.AND_Integer_MULTI(VarInt:Q,i:n,VarInt:1...VarInt:n)

;Display.Clear		EQU	0x5900	; Display lschen  Display.Clear() obsolete
;Display.ClearColorOld	EQU	0x5901	; Display mit Farbe lschen (obsolete)
Display.SetBrightness	EQU	0x5902	; Display Helligkeit Hintergrundbeleuchtung einstellen
Display.Prepare		EQU	0x5903	; Display nur ins AVR schreiben (vorbereiten)
Display.ShowWindow	EQU	0x5904	; Display Bereich vom AVR ins RVR schreiben
Display.Show		EQU	0x5905	; Display ganzes Display vom AVR ins RVR schreiben
Display.Direct		EQU	0x5906	; Display nur ins RVR schreiben (anzeigen)
Display.RestoreWriteMode EQU	0x5907	; Display alter WriteMode wieder herstellen
Display.ClearColor	EQU	0x5908	; Display mit Farbe lschen (VarInt)
Display.Clear		EQU	0x5909	; Display lschen  Display.Clear()		25.09.2006 V0$40

Display.ShowTranslateWindow EQU 0x590A	; Displaywindow translieren und anzeigen	27.11.2006 V0$45

Display.CopyWindow	EQU 	0x590B	; Displaywindow kopieren			30.01.2006 V0$50

Display.WriteCommand	EQU	0x590C	; Kommando ins EVECMD-Register schreiben	14.07.2007 V0$50
					; Display.WriteCommand(VarInt)

Display.CopyLineRight	EQU	0x590D	; Linie nach rechts kopieren			16.07.2007 V0$50
					; Display.CopyLineRight()

Display.CopyLineDown	EQU	0x590E	; Linie nach unten ins RVR kopieren		16.07.2007 V0$50
					; Display.CopyLineDown()

Display.ShowLineRight	EQU	0x590F	; Linie nach rechts ins RVR kopieren		16.07.2007 V0$50
					; Display.ShowLineRight()

Display.ShowLineDown	EQU	0x5910	; Linie nach unten kopieren			16.07.2007 V0$50
					; Display.ShowLineDown()

Display.CopyLineRightLength EQU	0x5911	; Linie nach rechts kopieren			18.07.2007 V0$50
					; Display.CopyLineRightLength(VarInt:Lnge)

Display.CopyLineDownLength EQU	0x5912	; Linie nach unten ins RVR kopieren		18.07.2007 V0$50
					; Display.CopyLineDownLength(VarInt:Lnge)

Display.ShowLineRightLength EQU	0x5913	; Linie nach rechts ins RVR kopieren		18.07.2007 V0$50
					; Display.ShowLineRightLength(VarInt:Lnge)

Display.ShowLineDownLength EQU	0x5914	; Linie nach unten kopieren			18.07.2007 V0$50
					; Display.ShowLineDownLength(VarInt:Lnge)


Display.ShowWindowEffect EQU	0x5915	; Display Bereich vom AVR ins RVR schreiben	22.06.2008 V0$60	
					; mit Effekt und Zeit in Vielfachen von 100us 
					; Display.ShowWindowEffect ( VarInt:ShowWindowEffekt,VarInt:Speed )

Display.Normal		EQU	0x560D	; schreibt in AVR und RVR			10.07.2008 V0$70					


;CallSubroutine		EQU	0x0026	; Subroutinenaufruf alt mit 16-Bit absoluten Adressen
;CallSubroutine		EQU	0x5810	; Subroutinenaufruf neu mit 24-Bit absoluter Adresse
;CallSubroutine		EQU	0x5811	; Subroutinenaufruf neu mit 24-Bit relativer Adresse 4.6.2006 gendert 12.08.2006
FillScreenPattern	EQU	0x002F	; Bildschirm mit Muster fllen, z. Linien
TextBox_A_Nibble	EQU	0x0030	; HEX-Nibble in TextBox A ausgeben
TextBox_A_Byte		EQU	0x0031	; HEX-Bytes in TextBox A ausgeben
TextBox_A_Word		EQU	0x0032	; Word in TextBox A ausgeben
TextBox_A_Short		EQU	0x0033	; Bytes als Short Integer 0..255 in TextBox_A ausgeben
TextBox_A_Cardinal	EQU	0x0034	; Word als Cardinal  0..65535 in TextBox_A ausgeben
TextBox_A_Long		EQU	0x0035	; Longword 0..9'999'999 in TextBox_A ausgeben
TextBox_A_CRLF		EQU	0x0036	; CRLF in TextBox_A ausgeben
TextBox_A_TabulatorAbs	EQU	0x0037	; Tabulator CURR_XPOS:=XPOS+Offset

;InOut.Read_ADC		EQU	0x4900	; InOut.Read_ADC(0,EI_Int_0) ; A/D Wert einlesen  5.6.2006
;					; InOut.Read_ADC(VarInt,VarInt)	; Kanal-Nummer, ZielVariable

InOut.Read_ADC		EQU	0x4901	; A/D Wert einlesen  				25.9.2006  V0$40
					; InOut.Read_ADC(VarInt:Kanal,VarInt:ADC-Wert)	; Kanal-Nummer, ZielVariable

InOut.DigitalOutputDriver EQU	0x4902	; Digitale Output-Funktion
					; InOut.DigitalOutputDriver(VarInt:Output_OP90,VarInt:Funktion)

InOut.PWM_Out		EQU	0x4903	; PWM-Ausgabe
					; InOut.PWM_Out(VarInt:OP72/OP76,VarInt:Value)
					; Wertebereich 0..1000

InOut.Read_Input	EQU	0x4904	; Digital-Input einlesen
					; InOut.Read_Input(VarInt:IP91,VarInt:Value)
					; Value: 0 = low   1 = high

InOut.DA_Out_8		EQU	0x4905	; DA-Output setzten
					; InOut.DA_Out_8(VarInt:OP94,VarInt:Value)
					
InOut.UpCounter_Get	EQU	0x4906	; UpCounter einlesen				19.10.2009
					; InOut.UpCounter_Get(VarInt:Input_IP91,VarLong:Counter) 

InOut.UpCounter_Reset	EQU	0x4907	; UpCounter resetten				19.10.2009
					; InOut.UpCounter_Reset(VarInt:Input_IP91)

InOut.DownCounter_Get	EQU	0x4908	; DownCounter einlesen				19.10.2009
					; InOut.DownCounter_Get(VarInt:Input_IP91,VarLong:Counter)

InOut.DownCounter_Load	EQU	0x4909	; DownCounter mit Wert laden
					; InOut.DownCounter_Load(VarInt:Input_IP91,VarLong:Counter)

InOut.DownCounter_Zero_InstallLocal EQU 0x490E ; lokale Routine installieren		19.10.2009
					; InOut.DownCounter_Zero_InstallLocal(labelRelative24:Event)

Sound.SetSamplingRate	EQU	0x490A	; Sound SamplingRate setzen 		15.01.2009
					; Sound.SetSamplingRate(VarInt:SamplingRate_11025)

Sound.PlaySamples	EQU	0x490B	; Sound Samples abspielen		15.01.2009
					; Sound.PlaySamples(VarInt:Sound_MODE_STEREO,VarStr:File,VarLong:StartOffset,VarLong:NoOfSamples,VarInt:Loops)

Sound.InstallLocal	EQU	0x490C	; Sound Event installieren		18.01.2009
					; Sound.InstallLocal(labelRelative24:Event)

Sound.SetBitsPerSample	EQU	0x490D	; Sound Bits per Sample 8 oder 16	19.01.2009
					; Sound.SetBitsPerSample( VarInt:BitsPerSample )



I2C.Init		EQU	0x4921	; 					26.10.2009
					; I2C.Init();I2C-Master Intialisation


I2C.Start		EQU	0x4922	; 					26.10.2009
					; I2C.Start();I2C-Master sends Start sequence

I2C.RepeatedStart	EQU	0x4923	; 					26.10.2009
					; I2C.RepeatedStart();I2C-Master sends RepeatedStart sequence


I2C.Stop		EQU	0x4924	; 					26.10.2009
					; I2C.Stop();I2C-Master sends Stop sequence

I2C.WriteConfigByte	EQU	0x4925	; 					26.10.2009
					; I2C.WriteConfigByte(VarInt:SlaveAddress,VarInt:I2C_DATADIRECTION_) ;I2C-Master sends SlaveAddress and the data direction


I2C.WriteByte		EQU	0x4926	;					26.10.2009
					; I2C.WriteByte(VarInt:Value) ;I2C-Master sends a Byte

I2C.ReadStreamByte	EQU	0x4927	; 					26.10.2009
					; I2C.ReadStreamByte(VarInt:Value) ;I2C-Master reads a Byte


I2C.ReadLastByte	EQU	0x4928	; 					26.10.2009
					; I2C.ReadLastByte(VarInt:Value) ;I2C-Master reads a Byte


I2C.SetMode		EQU 	0x4929	; 					26.10.2009
					; I2C.SetMode(VarInt:I2C_MODE_) ;Sets the I2C Datarate


Buzzer.Off		EQU	0x4931	;					14.11.2009
					; Buzzer.Off();Buzzer OFF

Buzzer.On		EQU	0x4932	;					14.11.2009
					; Buzzer.On();Buzzer ON

Buzzer.Timer		EQU	0x4933	; 					14.11.2009
					; Buzzer.Timer(VarInt:Time);Buzzer for Time ms on

Buzzer.Alarm		EQU	0x4934	; 					14.11.2009
					; Buzzer.Alarm(VarInt:ON_Time,VarInt:OFF_Time,VarInt:Pulse,VarInt:Pause,VarInt:Loops);Buzzer Alarmpattern

Buzzer.Click		EQU	0x4935	; 					14.11.2009
					; Buzzer.Click();Buzzer Click

Buzzer.Touch		EQU	0x4936	; 					14.11.2009
					; Buzzer.Touch(VarInt:Time);Buzzer on at every Touchdown	


;GetADC			EQU	0x0043	; ADC-Wert einlesen und in Register ablegen
LabelPrintWord		EQU	0x0044	; Word in ein Label schreiben

;SerialText		EQU	0x004C	; Text ber die serielle Schnittstelle ausgeben

;JumpIntegerEqual_Imm	EQU	0x004D	; Sprung, falls Register und Immediate-Wert gleich sind.
;JumpIntegerGreater_Reg	EQU	0x4A04	; Sprung, falls Register1 grsser als Register2
;Jump_IF_BitSet_Reg	EQU	0x4A05	; Sprung, falls Bit, dessen Nummer im Register angegeben ist, gesetzt ist
;Jump_IF_BitSet_Imm	EQU	0x4A06	; Sprung, falls Bit, dessen Nummer diekt angegeben ist, gesetzt ist
;Jump_IF_BitClear_Reg	EQU	0x4A07	; Sprung, falls Bit, dessen Nummer im Register angegeben ist, gelscht ist
;Jump_IF_BitClear_Imm	EQU	0x4A08	; Sprung, falls Bit, dessen Nummer diekt angegeben ist, gelscht ist

JumpRelative24		EQU	0x4A03	; (labelRelative24)	braucht der Compiler
Jump			EQU	0x4A03	; Jump(labelRelative24)
;JumpRelative		EQU	0x4A09	; (LabelRel)


IFINT_EQU_THEN		EQU	0x4A0A	; (labelRelative24,VarInt,VarInt) 	angepasst 5.6.2006
IFINT_NE_THEN		EQU	0x4A0B	; (labelRelative24,VarInt,VarInt)
IFINT_LT_THEN		EQU	0x4A0C	; (labelRelative24,VarInt,VarInt)
IFINT_LE_THEN		EQU	0x4A0D	; (labelRelative24,VarInt,VarInt)
IFINT_GT_THEN		EQU	0x4A0E	; (labelRelative24,VarInt,VarInt)
IFINT_GE_THEN		EQU	0x4A0F	; (labelRelative24,VarInt,VarInt)
FOR_Integer		EQU	0x4A10	; (labelRelative24,VarInt,VarInt,VarInt,i)	Zhlvariable,Start,Ende,Step
					; FOR Zhlvariable := Start TO Ende STEP 1

NEXT_UPU_Integer	EQU	0x4A10	; UP unsigned integer
					; (labelRelative24,VarInt,VarInt,VarInt)	Sprungziel,Zhlvariable,Ende,Step
NEXT_UPS_Integer	EQU	0x4A11	; UP signed integer
					; (labelRelative24,VarInt,VarInt,VarInt)	Sprungziel,Zhlvariable,Ende,Step

NEXT_DNU_Integer	EQU	0x4A12	; DOWN unsigned integer
					; (labelRelative24,VarInt,VarInt,VarInt)	Sprungziel,Zhlvariable,Ende,Step
NEXT_DNS_Integer	EQU	0x4A13	; DOWN signed integer
					; (labelRelative24,VarInt,VarInt,VarInt)	Sprungziel,Zhlvariable,Ende,Step

Jump_IF_NotZero_Integer	EQU	0x4A14	; (labelRelative24,VarInt)	SprungZiel,zu testende Variable 	01.07.2006

Jump_IF_Zero_Integer	EQU	0x4A15	; (labelRelative24,VarInt)	SprungZiel,zu testende Variable 	01.07.2006


ON_ERROR_GOTO		EQU	0x4A16	; ON_ERROR_GOTO(labelRelative24)			14.09.2006 V0$40
					; Sprung falls Fehler aufgetreten ist
					; prft das eI.Success-Register und springt, falls nicht Success


DEC_JUMP_NZ_INTEGER	EQU	0x4A17	; Dekrementiert Integer, Sprung falls nicht Null	15.09.2006 V0$40
					; DEC_JUMP_NZ_INTEGER	(labelRelative24:Sprungziel,VarInt:LoopCounter)

DEC_JUMP_NZ_LONG	EQU	0x4A18	; Dekrementiert Integer, Sprung falls nicht Null	15.09.2006 V0$40
					; DEC_JUMP_NZ_LONG	(labelRelative24:Sprungziel,VarLong:LoopCounter)
		
Jump_IF_BitSet_Integer	EQU	0x4A19	; Sprung, falls BitNummer, in Integer gesetzt ist.	16.09.2006 V0$40
					; Jump_IF_BitSet_Integer(labelRelative24:Sprungziel,VarInt:TestInteger,VarInt:BitNummer)

Jump_IF_BitClear_Integer EQU	0x4A1A	; Sprung, falls BitNummer, in Integer gelscht ist.	16.09.2006 V0$40
					; Jump_IF_BitClear_Integer(labelRelative24:Sprungziel,VarInt:TestInteger,VarInt:BitNummer)


Jump_IF_A_EQ_B_Integer	EQU	0x4A1B	; Sprung, falls A=B
					; Jump_IF_A_EQ_B_Integer(labelRelative24:Sprungziel,VarInt:A,VarInt:B)

Jump_IF_A_NE_B_Integer	EQU	0x4A1C	; Sprung, falls A!=B
					; Jump_IF_A_NE_B_Integer(labelRelative24:Sprungziel,VarInt:A,VarInt:B)

Jump_IF_A_GT_B_Integer	EQU	0x4A1D	; Sprung, falls A > B
					; Jump_IF_A_GT_B_Integer(labelRelative24:Sprungziel,VarInt:A,VarInt:B)

Jump_IF_A_GE_B_Integer	EQU	0x4A1E	; Sprung, falls A >= B
					; Jump_IF_A_GE_B_Integer(labelRelative24:Sprungziel,VarInt:A,VarInt:B)

Jump_IF_A_LT_B_Integer 	EQU	0x4A1F	; Sprung, falls A < B
					; Jump_IF_A_LT_B_Integer(labelRelative24:Sprungziel,VarInt:A,VarInt:B)

Jump_IF_A_LE_B_Integer 	EQU	0x4A20	; Sprung, falls A <= B
					; Jump_IF_A_LE_B_Integer(labelRelative24:Sprungziel,VarInt:A,VarInt:B)

Jump_IF_NotZero_Long	EQU	0x4A21	; Sprung falls A NotZero
					; Jump_IF_NotZero_Long(labelRelative24:Sprungziel,VarLong:A)

Jump_IF_Zero_Long	EQU	0x4A22	; Sprung falls A Zero
					; Jump_IF_Zero_Long(labelRelative24:Sprungziel,VarLong:A)

Jump_IF_A_EQ_B_Long	EQU	0x4A23	; Sprung, falls A=B
					; Jump_IF_A_EQ_B_Long(labelRelative24:Sprungziel,VarLong:A,VarLong:B)

Jump_IF_A_NE_B_Long	EQU	0x4A24	; Sprung, falls A!=B
					; Jump_IF_A_NE_B_Long(labelRelative24:Sprungziel,VarLong:A,VarLong:B)

Jump_IF_A_GT_B_Long	EQU	0x4A25	; Sprung, falls A > B
					; Jump_IF_A_GT_B_Long(labelRelative24:Sprungziel,VarLong:A,VarLong:B)

Jump_IF_A_GE_B_Long	EQU	0x4A26	; Sprung, falls A >= B
					; Jump_IF_A_GE_B_Long(labelRelative24:Sprungziel,VarLong:A,VarLong:B)

Jump_IF_A_LT_B_Long 	EQU	0x4A27	; Sprung, falls A < B
					; Jump_IF_A_LT_B_Long(labelRelative24:Sprungziel,VarLong:A,VarLong:B)

Jump_IF_A_LE_B_Long 	EQU	0x4A28	; Sprung, falls A <= B
					; Jump_IF_A_LE_B_Long(labelRelative24:Sprungziel,VarLong:A,VarLong:B)

IFLONG_EQU_THEN		EQU	0x4A29	; IFLONG_EQU_THEN(labelRelative24:Sprungziel,VarLong:A,VarLong:B)
IFLONG_NE_THEN		EQU	0x4A2A	; IFLONG_NE_THEN(labelRelative24:Sprungziel,VarLong:A,VarLong:B)
IFLONG_LT_THEN		EQU	0x4A2B	; IFLONG_LT_THEN(labelRelative24:Sprungziel,VarLong:A,VarLong:B)
IFLONG_LE_THEN		EQU	0x4A2C	; IFLONG_LE_THEN(labelRelative24:Sprungziel,VarLong:A,VarLong:B)
IFLONG_GT_THEN		EQU	0x4A2D	; IFLONG_GT_THEN(labelRelative24:Sprungziel,VarLong:A,VarLong:B)
IFLONG_GE_THEN		EQU	0x4A2E	; IFLONG_GE_THEN(labelRelative24:Sprungziel,VarLong:A,VarLong:B)


Jump_IF_true		EQU	0x4A2F	; Sprung, falls eI.Boolean == true		; Version0$45 27.11.2006
					; Jump_IF_true (labelRelative24)

Jump_IF_false		EQU	0x4A30	; Sprung, falls eI.Boolean == false
					; Jump_IF_false(labelRelative24)		; Version0$45 27.11.2006


IFINT_BETWEEN_THEN	EQU	0x4A31	; Sprung, falls Integer zwischen
					; FOR i := A TO B STEP C
					; (labelRelative24:Sprungziel,VarInt:i,VarInt:A,VarInt:B)

ON_EVENT_GOTO		EQU	0x4A32	; ON_EVENT_GOTO(labelRelative24)		14.07.2007 V0$50
					; Sprung falls ein Event vorliegt
					; mit diesem Befehl kann eine Schleife verlassen werden,
					; wenn ein HotSpotEvent etc. anliegt 

ON_EVENT_Touch_GOTO	EQU	0x4A33	; ON_EVENT_Touch_GOTO(labelRelative24)		20.08.2007 V0$50
					; Sprung falls ein Touch-Event vorliegt
					; mit diesem Befehl kann eine Schleife verlassen werden,
					; wenn ein HotSpotEvent anliegt 

Jump_IF_Stack_true	EQU	0x4A34	; Sprung, falls Stackelement == true		; Version0$70 06.12.2008
					; Jump_IF_Stack_true (labelRelative24)
					; Das oberste Stackelement wird entfernt: SP := SP - 4

Jump_IF_Stack_false	EQU	0x4A35	; Sprung, falls Stackelement == false		; Version0$70 06.12.2008
					; Jump_IF_Stack_false (labelRelative24)
					; Das oberste Stackelement wird entfernt: SP := SP - 4


;SerialKeyInputSelect	EQU	0x0055	; whlt den SerialKey Input aus
;LabelPrintMinSec	EQU	0x0056	; Schreibt den Wert eines Integers als Min:Sec m:ss
;TimerContinue		EQU	0x0057	; Timer mit aktuellen Werten weiterlaufen lassen
;GotoViewOld		EQU	0x0058	; GotoView startet eine neue View aus dem CFC auf
GotoView		EQU	0x5812	; GotoView startet eine neue View aus dem CFC auf GotoView(VarInt)

GotoProject		EQU	0x5813	; GotoProject wechselt das Projekt und Startet eine View auf der CFC
					; GotoProject(VarStr:ProjectName,VarInt:ViewID)

ReturnFromProject	EQU	0x5814	; von Projekt zurckkehren zur aufrufenden View

;Finished		EQU	0x0059	; wartet hier (Schleife nicht mehr ntig)
;LabelPrintCardinal	EQU	0x005A	; Schreibt den Wert eines Intergers als Cardinal
;LoadParmRect_XYBHC	EQU	0x005B	; ldt die nachfolgenden Variablen fr ein Rechteck
;PotiDelay		EQU	0x005C	; liest den Analogwert vom Poti ein und wartet. 0-10s
;MatchTableExactInteger	EQU	0x005D	; vergleicht einen Eingangswert mit Werten in der
					; Lookuptable und liefert bei Gleichheit den in der
					; Tabelle gefundenen Wert zurck

MatchTableExactIntegerDimension	EQU	0x005E ; merdimensionale Tabelle
					; vergleicht einen Eingangswert mit Werten in der
					; Lookuptable und liefert bei Gleichheit den (die) in
					; der Tabelle gefundenen Wert(e) in die angegebenen
					; Variablen zurck

;DigitalOutputDriver	EQU	0x005F	; Digital Output Driver Funktion
;CopyWindow		EQU	0x0060	; Fenster kopieren



DisplayCenterHorizontal	EQU	0x0064	; DisplayCenterHorizontal(nameVariable,nameVariable)
DisplayCenterVertical	EQU	0x0065	; DisplayCenterVertical(nameVariable,nameVariable)
;AddInteger2Reg		EQU	0x0066	; Zwei Register zusammenzhlen und Resultat in 3.Register speichern


EVE.Load_XSTART		EQU	0x5609	; XSTART-Register laden
EVE.ReLoad_XSTART	EQU	0x560A	; XSTART-Register reloaden (EIFOX_XSTART--> EVE)



;Binary.BitSet_Reg	EQU	0x4200	; Bit setzen BitNummer ist in einem Register	obsolete
;Binary.BitSet_Imm	EQU	0x4201	; Bit setzen immediate				obsolete
;Binary.BitClear_Reg	EQU	0x4202	; Bit lschen BitNummer ist in einem Register	obsolete
;Binary.BitClear_Imm	EQU	0x4203	; Bit lschen immediate				obsolete
;Binary.BitNot_Reg	EQU	0x4204	; Bit invertieren BitNummer ist in einem Register obsolete
;Binary.BitNot_Imm	EQU	0x4205	; Bit invertieren immediate			obsolete


;Colors.MoreRed		EQU	0x4300	; vergrssert Rotanteil einer Farbe
;Colors.MoreGreen	EQU	0x4301	; vergrssert Grnanteil einer Farbe
;Colors.MoreBlue	EQU	0x4302	; vergrssert Blauanteil einer Farbe
;Colors.MoreRedLimit	EQU	0x4303	; vergrssert Rotanteil einer Farbe mit Limit bei Max
;Colors.MoreGreenLimit	EQU	0x4304	; vergrssert Grnanteil einer Farbe mit Limit bei Max
;Colors.MoreBlueLimit	EQU	0x4305	; vergrssert Blauanteil einer Farbe mit Limit bei Max
;Colors.LessRed		EQU	0x4306	; vermindert Rotanteil einer Farbe
;Colors.LessGreen	EQU	0x4307	; vermindert Grnanteil einer Farbe
;Colors.LessBlue	EQU	0x4308	; vermindert Blauanteil einer Farbe
;Colors.LessRedLimit	EQU	0x4309	; vermindert Rotanteil einer Farbe mit Limit bei Min
;Colors.LessGreenLimit	EQU	0x430A	; vermindert Grnanteil einer Farbe mit Limit bei Min
;Colors.LessBlueLimit	EQU	0x430B	; vermindert Blauanteil einer Farbe mit Limit bei Min

;Colors.GetPixelColor	EQU	0x4316	; ldt ZielVariable mit der Farbe am Punkt(X/Y)
					; Colors.GetPixelColor(VarInt:Ziel,VarInt:X,VarInt:Y)			18.07.2006


;Colors.GetRed_5Bit	EQU	0x4317	; ldt ZielVariable mit 5-Bit Rotanteil der Farbe in QuellVariable	02.08.2006
					; Colors.GetRed_5Bit(VarInt:Ziel,VarInt:Color)
;Colors.GetGreen_5Bit	EQU	0x4318	; ldt ZielVariable mit 5-Bit Grnanteil der Farbe in QuellVariable	02.08.2006
					; Colors.GetGreen_5Bit(VarInt:Ziel,VarInt:Color)
;Colors.GetBlue_5Bit	EQU	0x4319	; ldt ZielVariable mit 5-Bit Blauanteil der Farbe in QuellVariable	02.08.2006
					; Colors.GetGreen_5Bit(VarInt:Ziel,VarInt:Color)(VarInt:Ziel,VarInt:Color)


;Draw.Pixel		EQU	0x4400	; Pixel zeichnen obsolete, neuer OpCode
;Draw.LineDownLength	EQU	0x4403	; Linie abwrts zeichnen, Lnge als Parameter
;Draw.LineUpLength	EQU	0x4405	; Linie aufwrts zeichnen, Lnge als Parameter
;Draw.LineLeftLength	EQU	0x4407	; Linie nach links zeichnen, Lnge als Parameter
;Draw.LineRightLength	EQU	0x4409	; Linie nach rechts zeichnen, Lnge als Parameter


;Math.MOD_Integer	EQU	0x4D02	; MOD_Integer (Resultat,Operand1,Operand2) (VarInt,VarInt,VarInt)
;Math.DIV_Integer	EQU	0x4D03	; DIV_Integer (Resultat,Operand1,Operand2) (VarInt,VarInt,VarInt)


;Math.MULS_Integer	EQU	0x4D07	; MULSInteger (Resultat,Operand1,Operand2) (VarInt,VarInt,VarInt)
;Math.INC_Integer	EQU	0x4D08	; INCInteger (Resultat)			  (VarInt)
;Math.DEC_Integer	EQU	0x4D09	; DECInteger (Resultat)			  (VarInt)
;Math.MOVE_Integer	EQU	0x4D10	; MOVE Integer(Resultat,Operand1)	  (VarInt,VarInt) 	18.08.2006 ausgebaut


;Math.MOVE_Long		EQU	0x4D30	; MOVE Long  (Resultat,Operand1)		22.06.2006



TestInteger		EQU	0x9999	; TestFunktion, nicht ausfhren! (VarInt)

EEPROM.Read_Integer	EQU	0x4504	; Integer aus EEPROM lesen			26.11.2007
					; EEPROM.Read_Integer(VarInt:EEPROM_Address,VarInt:Variable)

EEPROM.Write_Integer	EQU	0x4505	; Integer in EEPROM schreiben			26.11.2007
					; EEPROM.Write_Integer(VarInt:EEPROM_Address,VarInt:Variable)

EEPROM.Read_Long	EQU	0x4506	; Long aus EEPROM lesen				27.11.2007
					; EEPROM.Read_Long(VarInt:EEPROM_Address,VarLong:Variable)

EEPROM.Write_Long	EQU	0x4507	; Long in EEPROM schreiben			27.11.2007
					; EEPROM.Write_Long(VarInt:EEPROM_Address,VarLong:Variable)

EEPROM.Read_Single	EQU	0x4508	; Single aus EEPROM lesen			27.11.2007
					; EEPROM.Read_Single(VarInt:EEPROM_Address,VarSingle:Variable)

EEPROM.Write_Single	EQU	0x4509	; Single in EEPROM schreiben			27.11.2007
					; EEPROM.Write_Single(VarInt:EEPROM_Address,VarSingle:Variable)

EEPROM.Read_String	EQU	0x450A	; String aus EEPROM lesen
					; EEPROM.Read_String(VarInt:EEPROM_Address,VarStr:ZielString)

EEPROM.Write_String	EQU	0x450B	; String ins EEPROM schreiben
					; EEPROM.Write_String(VarInt:EEPROM_Address,VarStr:QuellString,VarInt:NoOfChar)


