; 01.05.2005 ------------------------------------------------------- 12.11.2009

; Eiger Register Definition File

; FileName:	Def_eVM_Registers_0$70.h

; Supported Hardware FOX1 Microcomputer and EVE-Anna Graphics Engine

; Copyright	S-TEC electronics AG
;		Industriestrasse 49
;		CH-6300 Zug
;		Switzerland
;		www.s-tec.ch
;		s-tec@bluewin.ch

; Autor		R. F. Oberhnsli


; Version	V1.01


; History	V1.00	10.06.2005 	first release
; Datum:  11.02.2006
; update: 21.03.2006			; Fehler behoben: Int A-F hatten falsche Werte!
; update: 12.08.2006			; Debug-Register eingefhrt
; update: 15.08.2006			; neue Schreibweise, die die Typenprfung untersttzt.
; update: 10.10.2006			; Version 0$45
; update: 16.06.2007			; Version 0$50 mit ColorScheme
; update: 14.09.2007			; Register fr Touch ein/ausschalten
; update: 16.06.2008			; ColorSchemeRegister
; update: 21.06.2008			; ColorPalette
; update: 21.11.2008			; DigitalInputs
; update: 21.12.2008			; eI.HS_State
; update: 10.01.2009			; Skin_Register-Namen vereinheitlicht
; update: 15.09.2009			; Hardware- und Display-Register


; The registers of the virtual machine are defined here


; -----------------------------------------------------------------------------


; ins SourceFile einfgen mit
; INCLUDEFILE	'Def_Eiger_Registers_0$70.INC'		; Typdefinitionen 08.07.2008	


; Deklaration von Registern:	
; Die Register haben die Syntax Kleinbuchstabe e, gefolgt von einem Zeichen, das den 
; Registertyp angibt, gefolgt von einem Punkt.

;	eI.ABC		bedeutet ein Integerregister
;	eL.ABC		bedeutet ein Longregister
;	eS.ABC		bedeutet ein Singleregister
;	eD.ABC		bedeutet ein Doubleregister
;	e$.ABC		bedeutet ein Stringregister


	
;$+REGISTER

; Integer Register der eiger Virtual Machine  eVM -----------------------------
; Diese Register knnen frei verwendet werden. Mit diesen Registern
; kann zwischen den Views Variablen ausgetauscht werden 

eI.R00			EQU	0x0000	; Integer Register R00
eI.R01			EQU	0x0001	; Integer Register R01
eI.R02			EQU	0x0002	; Integer Register R02
eI.R03			EQU	0x0003	; Integer Register R03
eI.R04			EQU	0x0004	; Integer Register R04
eI.R05			EQU	0x0005	; Integer Register R05
eI.R06			EQU	0x0006	; Integer Register R06
eI.R07			EQU	0x0007	; Integer Register R07
eI.R08			EQU	0x0008	; Integer Register R00
eI.R09			EQU	0x0009	; Integer Register R01
eI.R10			EQU	0x000A	; Integer Register R02
eI.R11			EQU	0x000B	; Integer Register R03
eI.R12			EQU	0x000C	; Integer Register R04
eI.R13			EQU	0x000D	; Integer Register R05
eI.R14			EQU	0x000E	; Integer Register R06
eI.R15			EQU	0x000F	; Integer Register R07

; Geometrie-Register ----------------------------------------------------------
; Pixelangaben fr das Zeichnen von geometrischen Figuren werden in diesen
; Registern bergeben

eI.Pos_X1		EQU	0x0010	; X1-Position fr Geometriefunktionen
eI.Pos_Y1		EQU	0x0011	; Y1-Position fr Geometriefunktionen
eI.Pos_X2		EQU	0x0012	; X2-Position fr Geometriefunktionen
eI.Pos_Y2		EQU	0x0013	; Y2-Position fr Geometriefunktionen
eI.Width		EQU	0x0014	; Breite
eI.Height		EQU	0x0015	; Hhe
eI.HalfAxis_a		EQU	0x0016	; Halbachse a
eI.HalfAxis_b		EQU	0x0017	; Halbachse b
eI.Radius		EQU	0x0018	; Radius


; Farb-Register ---------------------------------------------------------------
; Farben fr zu zeichnende Objekte werden in diesen Registern bergeben

eI.FillColor		EQU	0x0019	; Fllfarbe fr Flchen
eI.LineColor		EQU	0x001A	; Linienfarbe
eI.TextColor		EQU	0x001B	; Textfarbe (Buchstaben)
eI.BackColor		EQU	0x001C	; Hintergrundfarbe Text


eI.Status		EQU	0x001D	; Status Register fr Error-Codes etc. sucess/failed


eI.FontNumber		EQU	0x001E	; Speichert aktuelle FontNumber
eI.BorderStyle		EQU	0x001F	; BorderStyle Register fr BorderStyle_Type
eI.DrawStringBehaviour	EQU	0x0020	; DrawStringBehavior: Verhalten einer Texbox
eI.Position		EQU	0x0021	; Text Position innerhalb des Labels ersetzt Alignment_Type
eI.Orientation		EQU	0x0022	; Text Orientation
eI.Appearance		EQU	0x0023	; Appearance: Appearance_Type
eI.Language		EQU	0x0024	; gewhle Sprache: Language_Type
eI.SpaceLeft		EQU	0x0025	; Abstand links bei Label
eI.SpaceRight		EQU	0x0026	; Abstand rechts bei Label
eI.VerticalAdjust	EQU	0x0027	; vertikale Anpassung
eI.Delay		EQU	0x0028	; Delay-Register
eI.ViewID		EQU	0x0029	; Aktuelle ViewID
eI.ViewID_Old		EQU	0x002A	; alte (vorhergehende) ViewID


eI.Timer_00		EQU	0x002B	; Timer 0 Register
eI.Timer_01		EQU	0x002C	; Timer 1 Register
eI.Timer_02		EQU	0x002D	; Timer 2 Register
eI.Timer_03		EQU	0x002E	; Timer 3 Register
eI.Timer_04		EQU	0x002F	; Timer 4 Register
eI.Timer_05		EQU	0x0030	; Timer 5 Register
eI.Timer_06		EQU	0x0031	; Timer 6 Register
eI.Timer_07		EQU	0x0032	; Timer 7 Register
eI.Mouse_X		EQU	0x0033	; Mouse X Register
eI.Mouse_Y		EQU	0x0034	; Mouse Y Register
eI.Mouse_Key		EQU	0x0035	; Mouse Key Register
eI.IconNumber		EQU	0x0036	; Icon Nummer

eI.ErrorCode		EQU	0x0038	; ErrorCode vom Typ enum ErrorCodes

eI.DA_P76		EQU	0x0039	; D/A Wert fr Port P76


eI.Mouse_X_Down		EQU	0x003A	; Mouse Down X-Koordinate
eI.Mouse_Y_Down		EQU	0x003B	; Mouse Down Y-Koordinate

eI.Mouse_X_Up		EQU	0x003C	; Mouse Up X-Koordinate
eI.Mouse_Y_Up		EQU	0x003D	; Mouse Up Y-Koordinate

eI.P90_Time_ON		EQU	0x003E	; ON-Zeit P90 Driver
eI.P90_Time_OFF		EQU	0x003F	; OFF-Zeit P90 Driver
eI.P90_Pulse_Count	EQU	0x0040	; Anzahl Pulse P90 Driver
eI.P90_Output		EQU	0x0041	; Rckgabewert Ausgang P90 0/1
eI.P92_Time_ON		EQU	0x0042	; ON-Zeit P92 Driver
eI.P92_Time_OFF		EQU	0x0043	; OFF-Zeit P92 Driver
eI.P92_Pulse_Count	EQU	0x0044	; Anzahl Pulse P92 Driver
eI.P92_Output		EQU	0x0045	; logischer Rckgabewert Ausgang P92 0/1


eI.Garbage		EQU	0x0046	; Wird ein Rckgabewert nicht gebraucht,
					; wird er in Garbage entsorgt.

; SystemInfo: Displaygrsse und Orientierung ----------------------------------
eI.DisplayMax_X		EQU	0x0047	; Maximale X-Koordinate		
eI.DisplayMax_Y		EQU	0x0048	; Maximale Y-Koordinate
eI.DisplayWidth		EQU	0x0049	; Display Breite
eI.DisplayHeight	EQU	0x004A	; Display Hhe
eI.DisplayOrientation	EQU	0x004B	; Display Orientierung "L" = landscape
					;                      "P" = portrait


eI.DisplayColor		EQU	0x004C	; Display-Farbe
eI.XSTART		EQU	0x004D	; XSTART-Register
eI.Brightness		EQU	0x004E	; Helligkeit Hintergrundbeleuchtung
	

eI.HorizontalAdjust	EQU	0x0064	; Horizontale Anpassung

eI.Offset_X		EQU	0x0065	; Offset_X
eI.Offset_Y		EQU	0x0066	; Offset_Y

eI.Absolute_X1		EQU	0x0067	; Absolute X Position (Read only)
					; Summe von eI.Pos_X1 und eI.Offset_X
eI.Absolute_Y1		EQU	0x0068	; Absolute Y Position (Read only)
					; Summe von eI.Pos_Y1 und eI.Offset_Y

eI.StackPointer		EQU	0x0069	; Stackpointer der eVM
			
eI.HotSpotGroup		EQU	0x006C	; HotSpot Gruppennummer


eI.HotSpotTag		EQU	0x006F	; HotSpot Tag: kann frei beschrieben werden
					; wird beim Installieren gelesen und in HotSpot-Tabelle gespeichert

eI.BackgroundColor	EQU	0x0070	; Hintergrundfarbe, auf die ein Label
					; gezeichnet wird. Ist fr gewisse Border
					; Styles ntig 10.07.2008

; HotSpot Rckgabewerte -------------------------------------------------------
; ein Hotspot liefert die Informationen in diesen Registern. Eine Methode
; der Transfer-Klasse bernimmt diese Werte in die Geometrieregister 
;
eI.HS_Pos_X		EQU	0x0080	; Rckgabewert X
eI.HS_Pos_Y		EQU	0x0081	; Rckgabewert Y
eI.HS_Width		EQU	0x0082	; Rckgabewert Breite
eI.HS_Height		EQU	0x0083	; Rckgabewert Hhe
eI.HS_Offset_X		EQU	0x0084	; Rckgabewert Offset X
eI.HS_Offset_Y		EQU	0x0085	; Rckgabewert Offset Y
eI.HS_Group		EQU	0x0086	; Rckgabewert Gruppe
eI.HS_Tag		EQU	0x0087	; Rckgabewert Tag
eI.HS_ID		EQU	0x0090	; Rckgabewert ID-Nummer des Hotspot nach Event
					; oder Installation		
eI.HS_State		EQU	0x0133	; Rckgabewert State des Hotspot nach Event
					; oder Installation		



eI.Display_WriteMode	EQU	0x0088	; Video Schreibmodus 01=RVR, 02 = AVR, 03= RVR und AVR


eI.HotSpot_ID		EQU	0x0089	; Rckgabewert der ID-Nummer nach Installation des HS


; Register fr die Stringkonversion -------------------------------------------
; Folgende Character werden von den Zahl zu String Konversionsroutinen gebraucht

					; eI_DecimalSeparatorChar
eI.DecimalSeparatorChar	EQU	0x0093	; Der DezimalSeparator trennt bei einer Zahl
					; die Vorkomma- von den Nachkommastellen
					; Default ".": also 0.5 kann aber auch "," 
					; sein also 0,5 oder wie in der Elektrotechnik
					; blich 1n5 fr 1,5nF


					; eI_FillChar
eI.FillChar		EQU	0x0094	; Default " ": fhrende Stellen werden mit diesem Character aufgefllt
					; mglich ist auch 0xA0, der nichtproportionale Space oder ein "*", um ein
					; Einfllen von leeren Feldern zu Verhindern (Einzahlungsschein)

					; eI_NumericChar
eI.NumericChar		EQU	0x0095	; Default "#": Wenn die Zahlendarstellung nicht mglich ist, wird dieses Zeichen
					; als Platzhalter ausgegeben



eI.HotKey_Tag		EQU	0x0096	; TAG-ReturnValue fr HotKey, gibt den bei der Installation gespeicherten
					; Wert des Tags zurck

;eI.HotChar_GroupNumber	EQU	0x0097	; GruppenNummer fr HotChar (Returnvalue bei Event)


eI.ViewID_New		EQU	0x0098	; Register fr nchste ViewNummer



eI.Display_DumpMode	EQU	0x0099	; Gibt an, ob Display-Direct ins RVR schreibt, oder ins AVR und RVR
					; default: DumpMode=false funktioniert normal
					; DumpMode=true: trotz dem Befehl Display.Direct() wird ins AVR und RVR aus-
					; gegeben, um mit ScreenDump den Bildschirm abzubilden.





eI.eVM_DebugMode	EQU	0x009A	; Register fr die Funktionsweise des Debuggers der virtuellen Maschine
					; wenn 0x00 dann funktioniert die eVM normal
					; Die Bits haben folgende Bedeutung
					; Bit 0 : SingleStepMode 0=0FF  1=ON		; nach jedem Befehl stoppen
					; Bit 1 : TraceMode	 0=0FF  1=ON		; MDEC gibt Adresse und Token aus
					; Bit 2 : Debug-Bit	 0=0FF  1=ON		; wenn Bit gesetzt ist,
											; ist der Debugger aktiv
											; wird auch automatisch gesetzt
											; wenn Bit 1 ist, kann mit UART1
											; das Debugging aktiviert werden

eI.ColorThreshold	EQU	0x009B	; Register, das die Grauton-Schwelle angibt fr AutoColor_5Bit
					; und BlackWhithe_5Bit
					; Wertebereich 0..31 

; Datum und Zeitregister ------------------------------------------------------
; Diese Register bilden die bergabestruktur fr Datum- und Uhrzeit
; Mit den Methoden Time.Set und Time.Get werden sie gelesen oder geschrieben

eI.MSEC			EQU	0x009C	; MilliSekundenRegister [0..999]
eI.SEC			EQU	0x009D	; SekundenRegister [0..59]
eI.MIN			EQU	0x009E	; MinutenRegister  [0..59]
eI.HOURS		EQU	0x009F	; StundenRegister  [0..23]
eI.DATE			EQU	0x00A0	; TagRegister	   [1..31]
eI.MONTH		EQU	0x00A1	; MonatsRegister   [1..12]
eI.YEAR			EQU	0x00A2	; Jahr Register    [0..2100]
eI.DOW			EQU	0x00A3	; Day of Week	   [1..7]  1=Montag, 7=Sonntag


eI.Boolean		EQU	0x00A4	; BooleanRegister true/false  	24.11.2006
eI.DelimiterChar_1	EQU	0x00A5	; Trennzeichen als Delimiter	24.11.2006
eI.DelimiterChar_2	EQU	0x00A6	; Trennzeichen als Delimiter	24.11.2006


	

eI.LabelFont_Min_Char	EQU	0x00A7	; Minimum Character uInteger	24.03.2007		
eI.LabelFont_Max_Char	EQU	0x00A8	; Maximum Character uInteger	24.03.2007
eI.LabelFont_Nominal_Height EQU	0x00A9 	; Nominalhhe des Fonts (Pixel) 24.03.2007
eI.LabelFont_Cell_Height EQU	0x00AA	; Zellenhhe des Fonts (Pixel)	24.03.2007
eI.LabelFont_BottomLine	EQU	0x00AB	; Grundlinie der Character (Pixel) 24.03.2007
eI.StringWidth		EQU	0x00AC	; Breite des zuletzt geschrieben Strings (Pixel) 24.03.2007


; SystemInfo: Datum der virtuellen Maschine -----------------------------------
; In diesen Registern ist das Datum der eVM zugnglich (readonly)
	
eI.eVM_Day		EQU	0x00AD	; Datum der eVM: Tag 		25.03.2007	
eI.eVM_Month		EQU	0x00AE	; Datum der eVM: Monat		25.03.2007
eI.eVM_Year		EQU	0x00AF	; Datum der eVM: Jahr		25.03.2007

; 16.06.2007 ColorScheme ---------------------------------------------------------
eI.Skin_ViewTitelBackColor   EQU  0x00B0   ; CS_ViewTitelBackColor
eI.Skin_ViewTitelTextColor   EQU  0x00B1   ; CS_ViewTitelTextColor
eI.Skin_ViewBackColor        EQU  0x00B2   ; CS_ViewBackColor

eI.Skin_FormTitelBackColor   EQU  0x00B3   ; CS_FormTitelBackColor
eI.Skin_FormTitelTextColor   EQU  0x00B4   ; CS_FormTitelTextColor
eI.Skin_FormBackColor        EQU  0x00B5   ; CS_FormBackColor
eI.Skin_BtnActiveBackColor   EQU  0x00B6   ; CS_BtnActiveBackColor
eI.Skin_BtnActiveTextColor   EQU  0x00B7   ; CS_BtnActiveTextColor
eI.Skin_BtnInActiveBackColor EQU  0x00B8   ; CS_BtnInActiveBackColor
eI.Skin_BtnInActiveTextColor EQU  0x00B9   ; CS_BtnInActiveTextColor
eI.Skin_BtnFocusBackColor    EQU  0x00BA   ; CS_BtnFocusBackColor
eI.Skin_BtnFocusTextColor    EQU  0x00BB   ; CS_BtnFocusTextColor
eI.Skin_BtnSymbolColor       EQU  0x00BC   ; CS_BtnSymbolColor
eI.Skin_BaseColor            EQU  0x00BD   ; CS_Basisfarbe
eI.Skin_Color_1              EQU  0x00BE   ; CS_Color_1
eI.Skin_Color_2              EQU  0x00BF   ; CS_Color_2


eI.TouchIdle                 EQU  0x00C0   ; Touch Idle Counter
eI.TouchConfiguration        EQU  0x00C1   ; Touch Configuration true = ON (default) false = OFF

eI.Skin_BtnNavigateBackColor EQU  0x00C2   ; Skin_BtnNavigateBackColor
eI.Skin_BtnNavigateTextColor EQU  0x00C3   ; Skin_BtnNavigateTextColor
eI.Skin_BtnActiveDnBackColor EQU  0x00C4   ; Skin_BtnActiveDnBackColor
eI.Skin_BtnActiveDnTextColor EQU  0x00C5   ; Skin_BtnActiveDnTextColor

eI.Skin_ViewTextColor        EQU  0x00C6   ; Skin_ViewTextColor
eI.Skin_FormTextColor        EQU  0x00C7   ; Skin_FormTextColor

eI.Skin_EditBackColor        EQU  0x00C8   ; Skin_EditBackColor
eI.Skin_EditTextColor        EQU  0x00C9   ; Skin_EditTextColor
eI.Skin_EditMarkBackColor    EQU  0x00CA   ; Skin_EditMarkBackColor
eI.Skin_EditCursorColor	     EQU  0x00CB   ; Skin_EditCursorColor
eI.Skin_EditMarkTextColor    EQU  0x00CC   ; Skin_EditMarkTextColor
eI.Skin_BtnBorderUP          EQU  0x00CD   ; Skin_BtnBorderUP
eI.Skin_BtnBorderDN          EQU  0x00CE   ; Skin_BtnBorderDN
eI.Skin_TitelBorder          EQU  0x00CF   ; Skin_TitelBorder 10.08.2008


; 21.06.2008 ColorPalette -----------------------------------------------------
eI.Palette_Color_1	EQU	0x00D1	; dunkelste Farbe
eI.Palette_Color_2	EQU	0x00D2	; zweitdunkelste Farbe
eI.Palette_Color_3	EQU	0x00D3	; drittdunkelste Farbe
eI.Palette_Color_4	EQU	0x00D4	; viertdunkelste Farbe
eI.Palette_Color_5	EQU	0x00D5	; OriginalFarbe
eI.Palette_Color_6	EQU	0x00D6	; vierthellste Farbe
eI.Palette_Color_7	EQU	0x00D7	; dritthellste Farbe
eI.Palette_Color_8	EQU	0x00D8	; zweithellste Farbe
eI.Palette_Color_9	EQU	0x00D9	; hellste Farbe
eI.Palette_Color_AC	EQU	0x00DA	; autocolor zu Original Farbe
eI.Palette_Color_BW	EQU	0x00DB	; blackwhite zu Original Farbe
eI.Palette_Color_RG	EQU	0x00DC	; red-green swap zu Original Farbe
eI.Palette_Color_GB	EQU	0x00DD	; green-blue swap zu Original Farbe
eI.Palette_Color_BR	EQU	0x00DE	; blue-red swap zu Original Farbe
eI.Palette_Color_INV	EQU	0x00DF	; inverse zu Original Farbe


; frei von 0xDA-0xE0

; 21.06.2008 PaletteGrey ------------------------------------------------------
; zu den Farben gibt es die entsprechenden Grautne
eI.Palette_Grey_1	EQU	0x00E1	; dunkelster Grauwert
eI.Palette_Grey_2	EQU	0x00E2	; zweitdunkelster Grauwert
eI.Palette_Grey_3	EQU	0x00E3	; drittdunkelste Grauwert
eI.Palette_Grey_4	EQU	0x00E4	; viertdunkelste Grauwert
eI.Palette_Grey_5	EQU	0x00E5	; Grauwert zur OriginalFarbe
eI.Palette_Grey_6	EQU	0x00E6	; vierthellster Grauwert
eI.Palette_Grey_7	EQU	0x00E7	; dritthellster Grauwert
eI.Palette_Grey_8	EQU	0x00E8	; zweithellster Grauwert
eI.Palette_Grey_9	EQU	0x00E9	; hellster Grauwert
eI.Palette_Grey_AC	EQU	0x00EA	; autocolor zu Original Grauwert
eI.Palette_Grey_BW	EQU	0x00EB	; blackwhite zu Original Grauwert
eI.Palette_Grey_RG	EQU	0x00EC	; red-green swap zu Original Grauwert
eI.Palette_Grey_GB	EQU	0x00ED	; green-blue swap zu Original Grauwert
eI.Palette_Grey_BR	EQU	0x00EE	; blue-red swap zu Original Grauwert
eI.Palette_Grey_INV	EQU	0x00EF	; inverse zu Original Grauwert

; 29.06.2008 ColorPalette_Color75 ---------------------------------------------
; 75% der Palettenfarbe 25% der Mixfarbe

eI.Palette_Color75_1	EQU	0x00F1	; dunkelste Farbe 75%
eI.Palette_Color75_2	EQU	0x00F2	; zweitdunkelste Farbe 75%
eI.Palette_Color75_3	EQU	0x00F3	; drittdunkelste Farbe 75%
eI.Palette_Color75_4	EQU	0x00F4	; viertdunkelste Farbe 75%
eI.Palette_Color75_5	EQU	0x00F5	; OriginalFarbe 75%
eI.Palette_Color75_6	EQU	0x00F6	; vierthellste Farbe 75%
eI.Palette_Color75_7	EQU	0x00F7	; dritthellste Farbe 75%
eI.Palette_Color75_8	EQU	0x00F8	; zweithellste Farbe 75%
eI.Palette_Color75_9	EQU	0x00F9	; hellste Farbe 75%
eI.Palette_Color75_AC	EQU	0x00FA	; autocolor zu Farbe 75%
eI.Palette_Color75_BW	EQU	0x00FB	; blackwhite zu Farbe 75%
eI.Palette_Color75_RG	EQU	0x00FC	; red-green swap zu Farbe 75%
eI.Palette_Color75_GB	EQU	0x00FD	; green-blue swap zu Farbe 75%
eI.Palette_Color75_BR	EQU	0x00FE	; blue-red swap zu Farbe 75%
eI.Palette_Color75_INV	EQU	0x00FF	; inverse zu Farbe 75%

; 29.06.2008 ColorPalette_Color50 ---------------------------------------------
; 50% der Palettenfarbe 50% der Mixfarbe

eI.Palette_Color50_1	EQU	0x0101	; dunkelste Farbe 50%
eI.Palette_Color50_2	EQU	0x0102	; zweitdunkelste Farbe 50%
eI.Palette_Color50_3	EQU	0x0103	; drittdunkelste Farbe 50%
eI.Palette_Color50_4	EQU	0x0104	; viertdunkelste Farbe 50%
eI.Palette_Color50_5	EQU	0x0105	; OriginalFarbe 50%
eI.Palette_Color50_6	EQU	0x0106	; vierthellste Farbe 50%
eI.Palette_Color50_7	EQU	0x0107	; dritthellste Farbe 50%
eI.Palette_Color50_8	EQU	0x0108	; zweithellste Farbe 50%
eI.Palette_Color50_9	EQU	0x0109	; hellste Farbe 50%
eI.Palette_Color50_AC	EQU	0x010A	; autocolor zu Farbe 50%
eI.Palette_Color50_BW	EQU	0x010B	; blackwhite zu Farbe 50%
eI.Palette_Color50_RG	EQU	0x010C	; red-green swap zu Farbe 50%
eI.Palette_Color50_GB	EQU	0x010D	; green-blue swap zu Farbe 50%
eI.Palette_Color50_BR	EQU	0x010E	; blue-red swap zu Farbe 50%
eI.Palette_Color50_INV	EQU	0x010F	; inverse zu Farbe 50%

; 29.06.2008 ColorPalette_Color25 ---------------------------------------------
; 25% der Palettenfarbe 75% der Mixfarbe

eI.Palette_Color25_1	EQU	0x0111	; dunkelste Farbe 25%
eI.Palette_Color25_2	EQU	0x0112	; zweitdunkelste Farbe 25%
eI.Palette_Color25_3	EQU	0x0113	; drittdunkelste Farbe 25%
eI.Palette_Color25_4	EQU	0x0114	; viertdunkelste Farbe 25%
eI.Palette_Color25_5	EQU	0x0115	; OriginalFarbe 25%
eI.Palette_Color25_6	EQU	0x0116	; vierthellste Farbe 25%
eI.Palette_Color25_7	EQU	0x0117	; dritthellste Farbe 25%
eI.Palette_Color25_8	EQU	0x0118	; zweithellste Farbe 25%
eI.Palette_Color25_9	EQU	0x0119	; hellste Farbe 25%
eI.Palette_Color25_AC	EQU	0x011A	; autocolor zu Farbe 25%
eI.Palette_Color25_BW	EQU	0x011B	; blackwhite zu Farbe 25%
eI.Palette_Color25_RG	EQU	0x011C	; red-green swap zu Farbe 25%
eI.Palette_Color25_GB	EQU	0x011D	; green-blue swap zu Farbe 25%
eI.Palette_Color25_BR	EQU	0x011E	; blue-red swap zu Farbe 25%
eI.Palette_Color25_INV	EQU	0x011F	; inverse zu Farbe 25%

; SystemInfo: HotSpots --------------------------------------------------------
; In diesen Registern sind die Informationen ber HotSpots vorhanden (readonly)
	
eI.eVM_HotSpot_MAX	EQU	0x0130	; Maximal mgliche HotSpots    10.08.2008	
eI.eVM_HotSpot_COUNT	EQU	0x0131	; Momentan vorhandene HotSpots 10.08.2008
eI.DigitalInputs_15to0	EQU	0x0132	; Digitale Eingnge	       21.11.2008
eI.HS_State		EQU	0x0133	; Rckgabewert HS_State	       20.12.2008
eI.ProcessImage		EQU	0x0134	; Farbprozess bei EGI          24.12.2008

eI.HardwareCode		EQU	0x0135	; Register fr HardwareCode (FOX) 15.09.2009
eI.DisplayCode		EQU	0x0136	; Register fr DisplayCode 
eI_P92_Pause		EQU	0x0137	; Pause-Zeit P92 Driver		11.11.2009
eI.Touch_OffsetLeft	EQU	0x0138	; Touch Offset left		27.09.2009
eI_P92_Loops		EQU	0x0139	; Loop Counter P92 Driver	11.11.2009
eI.Touch_OffsetRight	EQU	0x013A	; Touch Offset right		27.09.2009

eI.Touch_OffsetTop	EQU	0x013C	; Touch Offset top		27.09.2009

eI.Touch_OffsetBottom	EQU	0x013E	; Touch Offset bottom		27.09.2009

eI.Touch_Xplus		EQU	0x0140	; Touch Analogwert Xplus	27.09.2009
eI.Touch_Xminus		EQU	0x0142	; Touch Analogwert Xminus	27.09.2009
eI.Touch_Yplus		EQU	0x0144	; Touch Analogwert Yplus	27.09.2009
eI.Touch_Yminus		EQU	0x0146	; Touch Analogwert Yminus	27.09.2009

eI.HS_EventType		EQU	0x0145	; Event Type Register (readonly)











; obsolete Bezeichnungen, nicht mehr verwenden --------------------------------

eI.Skin_ViewBodyColor        EQU  0x00B2   ; CS_ViewBodyColor (wie Back )
eI.Skin_FormBodyColor        EQU  0x00B5   ; CS_FormBodyColor ( wie Back )
eI.HK_Tag		     EQU  0x0096   ; TAG-ReturnValue fr HotKey, gibt den bei der Installation gespeicherten
					   ; Wert des Tags zurck


;$-REGISTER


;$+REGISTER



NextFree		EQU	0x0200	; nchste freie Zelle


EI_Int_Max		EQU	0x0300	; Maximale Integer VariablenNummer



















