
; 01.05.2005 ------------------------------------------------------- 06.01.2009

; Eiger Fonts: Font Number Definition File

; FileName:	Def_eiger_StackMachine_0$60.INC

; Supported Hardware FOX1 Microcomputer and EVE-Anna Graphics Engine

; Copyright	S-TEC electronics AG
;		Industriestrasse 49
;		CH-6300 Zug
;		Switzerland
;		www.s-tec.ch
;		s-tec@bluewin.ch

; Autor		R. F. Oberhnsli


; Version	V1.01


; History	V1.00	12.05.2008 	first release
;		V1.01	06.12.2008	PUSH_ImmUINT8

; All named Types are defined in this file



; -----------------------------------------------------------------------------


; ins SourceFile einfgen mit
; INCLUDEFILE	'Def_eiger_StackMachine_0$60.INC'		; Stack Machine Definitionen 30.11.2007

CONST		NOP_Stack	=	0x00			; no operation
CONST		PUSH_ImmUINT8	=	0x01			; PUSH Immediate unsigned Byte
CONST		PUSH_ImmUInt	=	0x02			; PUSH Immediate unsigned Integer
CONST		PUSH_ImmUINT16	=	0x02			; PUSH Immediate unsigned Integer

CONST		eFE_PushI_I	=	0x03			; PUSH Immediate Integer
CONST		PUSH_ImmInt	=	0x03			; PUSH Immediate Integer
CONST		PUSH_ImmINT16	=	0x03			; PUSH Immediate Integer

CONST		PUSH_RegInt	=	0x04			; PUSH Register Integer signed

CONST		eFE_PushV_I	= 	0x05			; PUSH Variable Integer
CONST		PUSH_VarInt	= 	0x05			; PUSH Variable Integer signed
CONST		PUSH_VarINT16	= 	0x05			; PUSH Variable Integer signed

CONST		PUSH_VarUInt	= 	0x09			; PUSH Variable Integer unsigned
CONST		PUSH_VarUINT16	= 	0x09			; PUSH Variable Integer unsigned


CONST		eFE_PushV_L	=	0x06			; PUSH Variable Long
CONST		PUSH_VarLong	=	0x06			; PUSH Variable Long
CONST		PUSH_VarINT32	=	0x06			; PUSH Variable Long


CONST		PUSH_ImmLong	=	0x07			; PUSH Immediate Long
CONST		PUSH_ImmINT32	=	0x07			; PUSH Immediate Long

CONST		PUSH_ImmByte	= 	0x08			; PUSH Immediate signed Byte
CONST		PUSH_ImmINT8	= 	0x08			; PUSH Immediate INT8

CONST		POP_RegInt	=	0x0C			; POP Register Integer

CONST		POP_VarInt_HWRD	=	0x0A			; POP Variable Integer HWRD ohne Bereichsprfung
CONST		POP_VarInt_LWRD	=	0x0B			; POP Variable Integer LWRD ohne Bereichsprfung
CONST		POP_VarUInt	=	0x0F			; POP Variable Integer unsigned
CONST		POP_VarInt	=	0x0D			; POP Variable Integer signed
CONST		eFE_PopV_L	=	0x0E			; POP Variable Long
CONST		POP_VarLong	=	0x0E			; POP Variable Long
CONST		POP_VarINT32	=	0x0E			; POP Variable Long


CONST		PUSH_VarINT8	= 	0x16			; PUSH Variable Byte signed
CONST		PUSH_VarUINT8	= 	0x17			; PUSH Variable Byte unsigned

CONST		POP_VarINT8	= 	0x18			; POP Variable Byte signed   (mit Bereichsprfung)
CONST		POP_VarUINT8	= 	0x19			; POP Variable Byte unsigned (mit Bereichsprfung)



CONST		ADD_Int		=	0x10			; (eFA_ADD_I)
CONST		SUB_Int		=	0x11			; (eFA_SUB_I)
CONST		MUL_Int		=	0x12			; (eFA_MUL_I)
CONST		DIV_Int		=	0x13			; (eFA_DIV_I)
CONST		MOD_Int		=	0x14			; (eFA_MOD_I) Modulo Operation
CONST		NEG_Int		=	0x15			; (eFA_NEG_I) Vorzeichenwechsel Operation 08.12.2008
CONST		ABS_Int		=	0x1B			; (eFA_ABS_I) Absolutbetrag Operation 08.12.2008



CONST		PUSH_VarSingle	=	0x20			; PUSH Variable Single
CONST		PUSH_ImmSingle	=	0x21			; POP Immediate Single
CONST		POP_VarSingle	=	0x22			; POP Variable Single
CONST		ADD_Single	=	0x23			; ADD Single
CONST		SUB_Single	=	0x24			; SUB Single
CONST		MUL_Single	=	0x25			; MUL Single
CONST		DIV_Single	=	0x26			; DIV Single
CONST		SIN_Single	=	0x27			; SIN Single
CONST		COS_Single	=	0x28			; COS single
CONST		TAN_Single	=	0x29			; TAN single
CONST		EXP_Single	=	0x2A			; EXP single
CONST		SQR_Single	=	0x2B			; SQR single
CONST		SQRT_Single	=	0x2C			; SQRT single


		; "Kranarme" fr die Adress-Berechnung von Elementen ARRAY/OBJEKTEN
CONST		PUSH_ADR24	=	0x30			; PUSH Address24

CONST		ADDR_ToElement	=	0x32			; Elementadresse aus Index berechnen

		; "Baggerschaufeln", um ARRAY-Elemente zu holen/versorgen -------------------
CONST		PUSH_FromAddrInt =	0x34			; Integer an Addresse auf Stack pushen
CONST		POP_ToAddrInt	=	0x35			; Integer auf Stack zu Adresse speichern
CONST		PUSH_FromAddrUInt =	0x36			; UInteger an Addresse auf Stack pushen
CONST		POP_ToAddrUInt	=	0x37			; UInteger auf Stack zu Adresse speichern
CONST		PUSH_FromAddrLong = 	0x38			; Long an Addresse auf Stack pushen
CONST		POP_ToAddrLong =	0x39			; Long auf Stack zu Adresse speichern
CONST		PUSH_FromAddrSingle = 	0x3A			; Single an Addresse auf Stack pushen
CONST		POP_ToAddrSingle =	0x3B			; Single auf Stack zu Adresse speichern

		; Boolean Funktionen 0=false alles andere = true ----------------------------
CONST		BOOL_NOT = 		0x40			; Boolean NOT
CONST		BOOL_AND = 		0x41			; Boolean AND
CONST		BOOL_OR = 		0x42			; Boolean OR
CONST		BOOL_XOR = 		0x43			; Boolean XOR


		; Compare Funktionen integer: liefert true oder false zurck ----------------
CONST		CMP_EQU_Int = 		0x44			; Compare Equal Integer       == 
CONST		CMP_NEQ_Int = 		0x45			; Compare Not Equal Integer   <>
CONST		CMP_GT_Int = 		0x46			; Compare Greater Than Integer   
CONST		CMP_GE_Int = 		0x47			; Compare Greater or Equal Than Integer
CONST		CMP_LT_Int = 		0x48			; Compare Less Than Integer
CONST		CMP_LE_Int = 		0x49			; Compare Less or Equal Than Integer

CONST		CMP_EQU_Single = 	0x4A			; Compare Equal Single       == 
CONST		CMP_NEQ_Single = 	0x4B			; Compare Not Equal Single   <>
CONST		CMP_GT_Single = 	0x4C			; Compare Greater Than Single   
CONST		CMP_GE_Single = 	0x4D			; Compare Greater or Equal Than Single
CONST		CMP_LT_Single = 	0x4E			; Compare Less Than Single
CONST		CMP_LE_Single = 	0x4F			; Compare Less or Equal Than Single

		; Bitwise Funktionen 32 Bit ----------------------------
CONST		BITWISE_NOT = 		0x50			; Boolean NOT
CONST		BITWISE_AND = 		0x51			; Boolean AND
CONST		BITWISE_OR = 		0x52			; Boolean OR
CONST		BITWISE_XOR = 		0x53			; Boolean XOR
CONST		ODD_Int		=	0x54			; true if ODD   06.01.2009
CONST		EVEN_Int	=	0x55			; true if EVEN  06.01.2009

CONST		eFE_End		=	0xED			; End
CONST		END_Stack	=	0xED			; End
