
; 01.05.2005 ------------------------------------------------------- 26.10.2009

; Eiger Fonts: Font Number Definition File

; FileName:	Def_Eiger_Types_0$70.INC

; Supported Hardware FOX1 Microcomputer and EVE-Anna Graphics Engine

; Copyright	S-TEC electronics AG
;		Industriestrasse 49
;		CH-6300 Zug
;		Switzerland
;		www.s-tec.ch
;		s-tec@bluewin.ch

; Autor		R. F. Oberhnsli


; Version	V1.01


; History	V1.00	10.06.2005 	first release
;		update	20.10.2005
;		update	12.03.2006	neue Borders
;		update  23.03.2006	orthogonale Borders
;		update	27.03.2006	separatorline-styles
;		update  27.03.2006	umgewandelt als INC-File
;		update  08.04.2006	Umbenennung von Definitionen
;		update	12.09.2006	Version 0$40
;		update	23.10.2006	Version 0$45
;		update	05.02.2007	Version 0$50
;		update	01.04.2007	Version 0$50 Digitalfonts
;		update	29.05.2007	Version 0$50 Baudraten
;		update  16.06.2007	Version 0$50 ColorScheme
;		update	12.08.2007	Version 0$50 Zeit und Datumsformate
;		update  02.09.2007	Version 0$50 Symbol32 erweitert
;		update	19.02.2008	Version 0$50 Baudraten 2400, 4800
;		update	21.06.2008	Version 0$60 ColorScheme und Palette
;		update	24.06.2008	Version 0$60 ShowEffects
;		update  08.07.2008      Version 0$70 more Colors
;		update  28.07.2008	Version 0$70 more Symbol32A
;		update	24.12.2008	Version 0$70 ProcessImage...
;		update	29.05.2009	Version 0$70 Baudrate 1200
;		update	19.10.2009	Version 0$70 Input_IP91 Output_OP92 etc.
;		update	26.10.2009	Version 0$70 I2C Constants


; All named Types are defined in this file

; The types include Definitions for Fonts,Borders etc.


; -----------------------------------------------------------------------------


; ins SourceFile einfgen mit
; INCLUDEFILE	'Def_Eiger_Types_0$70.INC'	; Typdefinitionen 06.01.2007


; enum Font_Type --------------------------------------------------------------

;

CONST	Font_Arial_7		=	1		; System 7 Mikroschrift
CONST	Font_Arial_8		=	2		; System 8 Kleinschrift
CONST	Font_Arial_10n		=	4		; Arial 10 Schrift
CONST	Font_System_9n		=	3		; System 9 Normalschrift
CONST	Font_Arial_12n		=	5		; Arial 12 Schrift
CONST	Font_Arial_14n		=	6		; Arial 14 Schrift
CONST	Font_Arial_16n		=	7		; Arial 16 Schrift
CONST	Font_Arial_20n		=	8		; Arial 20 Schrift
CONST	Font_Arial_24n		=	24		; Arial 24 normal System Grossschrift
CONST	Font_System_9bd		=	123		; System Titelschrift fett
CONST	Font_System_18bd	=	124		; System Titelschrift fett
;CONST	Font_Tekton_bold_24 	=	220		; Spezialschrift FW	
CONST	Font_Courier_9n		=	0x0109		; FixedSpace Schrift
CONST	Font_DigitalNumbers_24	=	222		; Spezialschrift Digitalanzeige nur Zifern und Punkt.		
CONST	Font_DigitalNumbers_32	=	221		; Spezialschrift Digitalanzeige nur Zifern und Punkt.		
CONST	Font_DigitalNumbers_48	=	223		; Spezialschrift Digitalanzeige nur Zifern und Punkt.		
CONST	Font_DigitalNumbers_64	=	224		; Spezialschrift Digitalanzeige nur Zifern und Punkt.		
CONST	Font_DigitalNumbers_16	=	225		; Spezialschrift Digitalanzeige nur Zifern und Punkt.		


; Font Digital Numbers: Der Font dient zur Darstellung von LCD- oder LED-7-Segment-Anzeigen.
; Im TG12_483.EVS sind Anwendungsbeispiele implementiert
; Die Fonts sind von Space 0x20 bis "F" = 0x46 definiert. Im Font enthalten sind ausser den
; Ziffern "0".."9" (0x30..0x39) die Buchstaben "A".."F". Damit lassen siche die Hex-Zahlen darstellen
; In den brigen Zeichen sind Buchstaben definiert, die sich gut darstellen lassen.

; 0x20: " "	Space, gleiche Breite wie Ziffern
; 0x21: "!"	Ausrufezeichen, Space, gleiche Breite wie Punkt und Doppelpunkt
; 0x22: """	Grossbuchstabe U		fr Liftanzeige
; 0x23: "#"	Grossbuchstabe H		fr Humidity, Henry, HALLO 
; 0x24: "$"	Grossbuchstabe L		fr Liter, HALLO 
; 0x25: "%"	Grad Zeichen			fr Grad Celsius oder Grad Fahrenheit
; 0x26: "&"	Kleinbuchstabe r		fr relative Feuchte rF oder rH
; 0x27: "'"	Kleinbuchstabe u		fr mikro uF uH uL
; 0x28: "("	Klammer auf
; 0x29: ")"	Klammer zu
; 0x2A: "*"	Malzeichen	reserve
; 0x2B	"+"	Grossbuchstabe	P		fr PLUS
; 0x2C	","	Kleinbuchstabe  o
; 0x2D	"-"	Minuszeichen	als Minuszeichen	Segment G
; 0x2E	"."	Punkt		als Punkt	kleinere Breite
; 0x2F	"/"	Kleinbuchstabe n		fr Nano
; 0x30..0x39	Ziffern 0..9
; 0x3A	":"	Doppelpunkt	als Doppelpunkt	kleinere Breite
; 0x3B	";"	Segment A
; 0x3C	"<"	Segment B
; 0x3D	"="	Segment C
; 0x3E	">"	Segment D
; 0x3F	"?"	Segment E
; 0x40	"@"	Segment F	
; 0x41..0x46	Grossbuchstaben A..F

; Wrter wie HALLO, Err, C, F, COOL, rF,rH, COOL, PLUS 








CONST	Font_EVI		=	0xFCCC		; Font ist in EVI-File gespeichert


; enum Language_Type ----------------------------------------------------------
CONST	englisch	=	0x0002		; Sprachcode englisch
CONST	deutsch		=	0x0003		; Sprachcode deutsch
CONST	franzoesisch	=	0x0008		; Sprachcode franzsisch
CONST	italienisch	=	0x0009		; Sprachcode italienisch
CONST	End_Of_Text_Table =	0xFFFF		; End of Text Table: Abschluss einer Sprachtabelle


; enum BorderStyle_Type -------------------------------------------------------
CONST	no_border		=	0x0000		; kein Rahmen
CONST	raised			=	0x0001		; erhhter Rahmen im Form-Style (obsololete)
CONST	form_raised		=	0x0001		; erhhter Rahmen im Form-Style
CONST	sunk			=	0x0002		; vertiefter Rahmen im Form-Style (obsolete)
CONST	form_sunk		=	0x0002		; vertiefter Rahmen im Form-Style
CONST	raised_1		=	0x0003		; erhhter Rahmen 1 pixel
CONST	sunk_1			=	0x0004		; vertiefter Rahmen 1 pixel aussen
CONST	color_raised		=	0x0005		; erhhter Farbrahmen fr Form	(obsolete)
CONST	color_form_raised	=	0x0005		; erhhter Farbrahmen fr Form
CONST	color_sunk		=	0x0006		; vertiefter Farbrahmen fr Form (obsolete)
CONST	color_form_sunk		=	0x0006		; vertiefter Farbrahmen fr Form
CONST	border_3D_6_up		=	0x0007		; 3D-Rahmen mit Farbwechsel
CONST	color_button_3D_raised 	=	0x0008		; Button_3D_raised
CONST	color_button_3D_sunk	=	0x0009		; Button_3D_sunk
CONST	color_button_3D_raised_big =	0x000A		; Button_3D_raised_big
CONST	color_button_3D_sunk_big =	0x000B		; Button_3D_sunk_big

CONST	border_color_button_soft_raised_big =	0x000C	; Softbutton 3D raised big 10.07.2008
CONST	border_color_button_soft_sunk_big   =	0x000D	; Softbutton 3D sunk big 10.07.2008

CONST	band_1_horizontal	=	0x051A		; oben und unten horizontale Linie 1 Pixel breit border_1_TB
CONST	band_2_horizontal	=	0x052A		; oben und unten horizontale Linie 2 Pixel breit border_2_TB
CONST	band_3_horizontal	=	0x053A		; oben und unten horizontale Linie 3 Pixel breit border_3_TB

CONST	band_1_vertical		=	0x0515		; links und rechts vertikale Linie 1 Pixel breit border_1_LR
CONST	band_2_vertical		=	0x0525		; links und rechts vertikale Linie 2 Pixel breit border_2_LR
CONST	band_3_vertical		=	0x0535		; links und rechts vertikale Linie 3 Pixel breit border_3_LR

CONST	groupBox		=	0x0010		; Rahmen im GroupBox-Style
CONST	color_raised_1		=	0x0011		; erhhter Rahmen farbig 1 pixel
CONST	color_sunk_1		=	0x0012		; vertiefter Rahmen farbig 1 pixel
CONST	color_groupBox		=	0x0013		; farbiger GroupBox-Style


CONST	raised_out		=	0x0081		; erhhter Rahmen aussen
CONST	sunk_out		=	0x0082		; vertiefter Rahmen aussen
CONST	raised_out_1		=	0x0083		; erhhter Rahmen 1 pixel aussen
CONST	sunk_out_1		=	0x0084		; vertiefter Rahmen 1 pixel aussen
CONST	color_raised_out 	=	0x0085		; erhhter Farbrahmen fr Form
CONST	color_sunk_out		=	0x0086		; vertiefter Farbrahmen fr Form
CONST	color_raised_out_1	=	0x0087		; erhhter Rahmen farbig 1 pixel aussen
CONST	color_sunk_out_1	=	0x0088		; vertiefter Rahmen farbig 1 pixel aussen



CONST	blackline_1		=	0x0110		; schwarze Linie 1 pixel dick
CONST	blackline_1_out		=	0x0111		; schwarze Linie 1 pixel dick aussen	
CONST	colorline_1		=	0x051F		; farbige Linie 1 pixel dick  		border_1_TLBR
CONST	colorline_1_out		=	0x061F		; farbige Linie 1 pixel dick aussen	border_1_TLBR_out
CONST	blackline_2		=	0x0120		; schwarze Linie 2 pixel dick
CONST	blackline_2_out		=	0x0221		; schwarze Linie 2 pixel dick aussen
CONST	colorline_2		=	0x052F		; farbige Linie 2 pixel dick		border_2_TLBR
CONST	colorline_2_out		=	0x062F		; farbige Linie 2 pixel dick aussen	border_2_TLBR_out

CONST	blackshadow_3		=	0x0403		; schwarzer Schatten 3 pixel
CONST	colorshadow_3		=	0x0404		; farbiger Schatten 3 pixel
CONST	blackshadow_4		=	0x0405		; schwarzer Schatten 4 pixel
CONST	colorshadow_4		=	0x0406		; farbiger Schatten 4 pixel
CONST	colorboxright_3		=	0x0407		; farbiger Box-Rahmen 3 pixel
CONST	colorboxright_4		=	0x0408		; farbiger Box-Rahmen 4 pixel


; Borders 1 Pixel dick innen ----------------------------------------------------
CONST	border_1_R		=	0x0511		; farbige Linie rechts
CONST	border_1_B		=	0x0512		; farbige Linie bottom
CONST	border_1_RB		=	0x0513		; farbige Linie rechts und bottom
CONST	border_1_L		=	0x0514		; farbige Linie links
CONST	border_1_LR		=	0x0515		; farbige Linie links und rechts
CONST	border_1_LB		=	0x0516		; farbige Linie links und unten
CONST	border_1_LBR		=	0x0517		; farbige Linie links, unten und rechts
CONST	border_1_T		=	0x0518		; farbige Linie top
CONST	border_1_TR		=	0x0519		; farbige Linie top und rechts
CONST	border_1_TB		=	0x051A		; farbige Linie top und bottom
CONST	border_1_TBR		=	0x051B		; farbige Linie top,bottom und rechts
CONST	border_1_TL		=	0x051C		; farbige Linie top und left
CONST	border_1_TLR		=	0x051D		; farbige Linie top left und right
CONST	border_1_TLB		=	0x051E		; farbige Linie top left und bottom
CONST	border_1_TLBR		=	0x051F		; farbige Linie rundherum


; Borders 2 Pixel dick innen ----------------------------------------------------
CONST	border_2_R		=	0x0521		; farbige Linie rechts
CONST	border_2_B		=	0x0522		; farbige Linie bottom
CONST	border_2_RB		=	0x0523		; farbige Linie rechts und bottom
CONST	border_2_L		=	0x0524		; farbige Linie links
CONST	border_2_LR		=	0x0525		; farbige Linie links und rechts
CONST	border_2_LB		=	0x0526		; farbige Linie links und unten
CONST	border_2_LBR		=	0x0527		; farbige Linie links, unten und rechts
CONST	border_2_T		=	0x0528		; farbige Linie top
CONST	border_2_TR		=	0x0529		; farbige Linie top und rechts
CONST	border_2_TB		=	0x052A		; farbige Linie top und bottom
CONST	border_2_TBR		=	0x052B		; farbige Linie top,bottom und rechts
CONST	border_2_TL		=	0x052C		; farbige Linie top und left
CONST	border_2_TLR		=	0x052D		; farbige Linie top left und right
CONST	border_2_TLB		=	0x052E		; farbige Linie top left und bottom
CONST	border_2_TLBR		=	0x052F		; farbige Linie rundherum

; Borders 3 Pixel dick innen ----------------------------------------------------
CONST	border_3_R		=	0x0531		; farbige Linie rechts
CONST	border_3_B		=	0x0532		; farbige Linie bottom
CONST	border_3_RB		=	0x0533		; farbige Linie rechts und bottom
CONST	border_3_L		=	0x0534		; farbige Linie links
CONST	border_3_LR		=	0x0535		; farbige Linie links und rechts
CONST	border_3_LB		=	0x0536		; farbige Linie links und unten
CONST	border_3_LBR		=	0x0537		; farbige Linie links, unten und rechts
CONST	border_3_T		=	0x0538		; farbige Linie top
CONST	border_3_TR		=	0x0539		; farbige Linie top und rechts
CONST	border_3_TB		=	0x053A		; farbige Linie top und bottom
CONST	border_3_TBR		=	0x053B		; farbige Linie top,bottom und rechts
CONST	border_3_TL		=	0x053C		; farbige Linie top und left
CONST	border_3_TLR		=	0x053D		; farbige Linie top left und right
CONST	border_3_TLB		=	0x053E		; farbige Linie top left und bottom
CONST	border_3_TLBR		=	0x053F		; farbige Linie rundherum

; Borders 4 Pixel dick innen ----------------------------------------------------
CONST	border_4_R		=	0x0501		; farbige Linie rechts
CONST	border_4_B		=	0x0502		; farbige Linie bottom
CONST	border_4_RB		=	0x0503		; farbige Linie rechts und bottom
CONST	border_4_L		=	0x0504		; farbige Linie links
CONST	border_4_LR		=	0x0505		; farbige Linie links und rechts
CONST	border_4_LB		=	0x0506		; farbige Linie links und unten
CONST	border_4_LBR		=	0x0507		; farbige Linie links, unten und rechts
CONST	border_4_T		=	0x0508		; farbige Linie top
CONST	border_4_TR		=	0x0509		; farbige Linie top und rechts
CONST	border_4_TB		=	0x050A		; farbige Linie top und bottom
CONST	border_4_TBR		=	0x050B		; farbige Linie top,bottom und rechts
CONST	border_4_TL		=	0x050C		; farbige Linie top und left
CONST	border_4_TLR		=	0x050D		; farbige Linie top left und right
CONST	border_4_TLB		=	0x050E		; farbige Linie top left und bottom
CONST	border_4_TLBR		=	0x050F		; farbige Linie rundherum

; Borders 1 Pixel dick aussen ----------------------------------------------------
CONST	border_1_R_out		=	0x0611		; farbige Linie rechts
CONST	border_1_B_out		=	0x0612		; farbige Linie bottom
CONST	border_1_RB_out		=	0x0613		; farbige Linie rechts und bottom
CONST	border_1_L_out		=	0x0614		; farbige Linie links
CONST	border_1_LR_out		=	0x0615		; farbige Linie links und rechts
CONST	border_1_LB_out		=	0x0616		; farbige Linie links und unten
CONST	border_1_LBR_out	=	0x0617		; farbige Linie links, unten und rechts
CONST	border_1_T_out		=	0x0618		; farbige Linie top
CONST	border_1_TR_out		=	0x0619		; farbige Linie top und rechts
CONST	border_1_TB_out		=	0x061A		; farbige Linie top und bottom
CONST	border_1_TBR_out	=	0x061B		; farbige Linie top,bottom und rechts
CONST	border_1_TL_out		=	0x061C		; farbige Linie top und left
CONST	border_1_TLR_out	=	0x061D		; farbige Linie top left und right
CONST	border_1_TLB_out	=	0x061E		; farbige Linie top left und bottom
CONST	border_1_TLBR_out	=	0x061F		; farbige Linie rundherum


; Borders 2 Pixel dick aussen ----------------------------------------------------
CONST	border_2_R_out		=	0x0621		; farbige Linie rechts
CONST	border_2_B_out		=	0x0622		; farbige Linie bottom
CONST	border_2_RB_out		=	0x0623		; farbige Linie rechts und bottom
CONST	border_2_L_out		=	0x0624		; farbige Linie links
CONST	border_2_LR_out		=	0x0625		; farbige Linie links und rechts
CONST	border_2_LB_out		=	0x0626		; farbige Linie links und unten
CONST	border_2_LBR_out	=	0x0627		; farbige Linie links, unten und rechts
CONST	border_2_T_out		=	0x0628		; farbige Linie top
CONST	border_2_TR_out		=	0x0629		; farbige Linie top und rechts
CONST	border_2_TB_out		=	0x062A		; farbige Linie top und bottom
CONST	border_2_TBR_out	=	0x062B		; farbige Linie top,bottom und rechts
CONST	border_2_TL_out		=	0x062C		; farbige Linie top und left
CONST	border_2_TLR_out	=	0x062D		; farbige Linie top left und right
CONST	border_2_TLB_out	=	0x062E		; farbige Linie top left und bottom
CONST	border_2_TLBR_out	=	0x062F		; farbige Linie rundherum

; Borders 3 Pixel dick aussen ----------------------------------------------------
CONST	border_3_R_out		=	0x0631		; farbige Linie rechts
CONST	border_3_B_out		=	0x0632		; farbige Linie bottom
CONST	border_3_RB_out		=	0x0633		; farbige Linie rechts und bottom
CONST	border_3_L_out		=	0x0634		; farbige Linie links
CONST	border_3_LR_out		=	0x0635		; farbige Linie links und rechts
CONST	border_3_LB_out		=	0x0636		; farbige Linie links und unten
CONST	border_3_LBR_out	=	0x0637		; farbige Linie links, unten und rechts
CONST	border_3_T_out		=	0x0638		; farbige Linie top
CONST	border_3_TR_out		=	0x0639		; farbige Linie top und rechts
CONST	border_3_TB_out		=	0x063A		; farbige Linie top und bottom
CONST	border_3_TBR_out	=	0x063B		; farbige Linie top,bottom und rechts
CONST	border_3_TL_out		=	0x063C		; farbige Linie top und left
CONST	border_3_TLR_out	=	0x063D		; farbige Linie top left und right
CONST	border_3_TLB_out	=	0x063E		; farbige Linie top left und bottom
CONST	border_3_TLBR_out	=	0x063F		; farbige Linie rundherum

; Borders 4 Pixel dick aussen ----------------------------------------------------
CONST	border_4_R_out		=	0x0601		; farbige Linie rechts
CONST	border_4_B_out		=	0x0602		; farbige Linie bottom
CONST	border_4_RB_out		=	0x0603		; farbige Linie rechts und bottom
CONST	border_4_L_out		=	0x0604		; farbige Linie links
CONST	border_4_LR_out		=	0x0605		; farbige Linie links und rechts
CONST	border_4_LB_out		=	0x0606		; farbige Linie links und unten
CONST	border_4_LBR_out	=	0x0607		; farbige Linie links, unten und rechts
CONST	border_4_T_out		=	0x0608		; farbige Linie top
CONST	border_4_TR_out		=	0x0609		; farbige Linie top und rechts
CONST	border_4_TB_out		=	0x060A		; farbige Linie top und bottom
CONST	border_4_TBR_out	=	0x060B		; farbige Linie top,bottom und rechts
CONST	border_4_TL_out		=	0x060C		; farbige Linie top und left
CONST	border_4_TLR_out	=	0x060D		; farbige Linie top left und right
CONST	border_4_TLB_out	=	0x060E		; farbige Linie top left und bottom
CONST	border_4_TLBR_out	=	0x060F		; farbige Linie rundherum


CONST	border_RoundCorner_all	= 	0x0700		; alle Ecken gerundet
CONST	border_RoundCorner_BCD	=	0x0701	
CONST	border_RoundCorner_ACD	=	0x0702	
CONST	border_RoundCorner_CD	=	0x0703	
CONST	border_RoundCorner_ABD	=	0x0704	
CONST	border_RoundCorner_BD	=	0x0705	
CONST	border_RoundCorner_AD	=	0x0706	
CONST	border_RoundCorner_D	=	0x0707	
CONST	border_RoundCorner_ABC	= 	0x0708	

CONST	border_RoundCorner_BC	=	0x0709	
CONST	border_RoundCorner_AC	=	0x070A	
CONST	border_RoundCorner_C	=	0x070B	
CONST	border_RoundCorner_AB	=	0x070C	
CONST	border_RoundCorner_B	=	0x070D	
CONST	border_RoundCorner_A	=	0x070E	
CONST	border_RoundCorner_none	=	0x070F		; alle Ecken eckig





; enum Style-Parameter fr Fill.LabelParamter und StyleProcessor
							; anwendbar fr Label
CONST	as_Skin_BtnBorderUP       =    	0x0800  	; as_Skin_BtnBorderUP
CONST	as_Skin_BtnBorderDN       =    	0x0801		; as_Skin_BtnBorderDN



; enum SeparatorLineStyles

CONST	no_line			=	0x0000		; keine Linie
CONST	color_sunk_2_horizontal	=	0x0001		; versunkene Linie 2 Pixel breit horizontal
CONST	color_sunk_2_vertical	=	0x0002		; versunkene Linie 2 Pixel breit vertikal





; enum Alignment_Type	---------------------------------------------------------
; Ausrichtung der Schrift in einem Label

CONST	Pos_topleft	=     0x1001          ; oben links
CONST	Pos_top		=     0x1004          ; oben mitte
CONST	Pos_topright	=     0x1002          ; oben rechts
CONST	Pos_left	=     0x0401          ; links mitte
CONST	Pos_center	=     0x0404          ; Zentrum
CONST	Pos_right	=     0x0402          ; rechts mitte
CONST	Pos_bottomleft	=     0x2001          ; unten links
CONST	Pos_bottom	=     0x2004          ; unten mitte
CONST	Pos_bottomright	=     0x2002          ; unten rechts


; enum Object_Type ------------------------------------------------------------
; gibt Objekt-Eigenschaften an

CONST	Label_Parent	=	0x0010		; Parent Label
CONST	Label_Child 	=	0x0011		; Child Label


; enum Appearence_Type --------------------------------------------------------

CONST	normal		=	0x0001		; Schrift normal
CONST	mirrored	=	0x0002		; Spiegelschrift

; enum Orientation_Type -------------------------------------------------------

CONST	Orientation_0deg	=	0	; Schrift normal 0 Grad
CONST	Orientation_90deg	=	90	; Schrift 90 Grad
CONST	Orientation_180deg	=	180	; Schrift 180 Grad
CONST	Orientation_270deg	=	270	; Schrift 270 Grad


; enum DrawStringBehavior -----------------------------------------------------

CONST	DrawStringBehavior_Cut			=	1
CONST	DrawStringBehavior_AutoCRLF		=	2
CONST	DrawStringBehavior_AutoScroll		=	3	
CONST	DrawStringBehavior_AutoScrollCRLF	=	4

; enum Pattern_Type -----------------------------------------------------------
; whlt bei der Funktion FillScreenPattern das Fllmuster aus

CONST	NoPattern	=	0	; eI.BackColor
CONST	SquareLines_08	=	1	; eI.BackColor, eI.LineColor
					; Malt einen Hintergrund mit 8er Huschen
CONST	SquareLines_10	=	2	; eI.BackColor, eI.LineColor
					; Malt einen Hintergrund mit 10er Huschen
CONST	SquareLines_12	=	3	; eI.BackColor, eI.LineColor
					; Malt einen Hintergrund mit 12er Huschen ca. 4mm fr 10.4" VGA
CONST	SquareLines_15	=	4	; eI.BackColor, eI.LineColor
					; Malt einen Hintergrund mit 15er Huschen ca. 5mm fr 10.4" VGA
CONST	SquareLines_16	=	5	; eI.BackColor, eI.LineColor
					; Malt einen Hintergrund mit 16er Huschen
CONST	SquareLines_20	=	6	; eI.BackColor, eI.LineColor
					; Malt einen Hintergrund mit 20er Huschen
CONST	Grid_10		=	8	; Malt Hintergrund mit 10er Grid

; enum eigerIcons -------------------------------------------------------------

CONST	Icon_NoImage				=	 0	; NoImageIcon
CONST	Icon_STOP_64x64				=	14	; STOP_64x64
CONST	Icon_ERROR_32				=	15	; Error
CONST	Icon_FRAGE_32				=	16	; Frage
CONST	Icon_ALERT_32				=	17	; Alert
CONST	Icon_INFO_32				=	18	; Info



; nicht verwenden ! (alte Bezeichnungen und ausgemustert)

CONST	NoImage					=	 0	; NoImageIcon
;CONST	OptionButton_notselected		=	 1	; OB not selected
;CONST	OptionButton_notselected_hovered	=	 2	; OB not selected hovered
;CONST	OptionButton_selected			=	 3	; OB selected
;CONST	OptionButton_selected_hovered		=	 4	; OB selected_hovered
;CONST	EigerIcon_16x16				=	 5	; EigerIcon
;CONST	CheckBox_NotSelected			=	 6	; CheckBox_NotSelected
;CONST	CheckBox_Selected1			=	 7	; CheckBox_Selected1
;CONST	CheckBox_Selected2			=	 8	; CheckBox_Selected2
;CONST	Schweiz_72x48				=	 9	; Schweiz_72x48
;CONST	France_72x48				=    	10	; France_72x48
;CONST	Deutschland_72x48			=	11	; Deutschland_72x48
;CONST	Italia_72x48				=	12	; Italia_72x48
;CONST	Oesterreich_72x48			=	13	; Oesterreich_72x48
CONST	STOP_64x64				=	14	; STOP_64x64
CONST	ERROR_32				=	15	; Error
CONST	FRAGE_32				=	16	; Frage
CONST	ALERT_32				=	17	; Alert
CONST	INFO_32					=	18	; Info
;CONST	End_pressed				=	19	; End_pressed	
;CONST	End_released				=	20	; End_released





; enum Mouse_Keys -------------------------------------------------------------

CONST	MouseNone				=	0	; keine MouseTaste
CONST	MouseLeftDown				=	1	; Mouse Left Down
CONST	MouseLeftUp				=	2	; Mouse Left Up


CONST	error		=	0
CONST	success		=	1


CONST	false		=	0
CONST	true		=	1
CONST	valid		=	2
CONST	invalid		=	3



; enum Size-Parameter fr Fill.LabelParamter und SizeProcessor

;CONST	no_change	=	0x8013			; Dieses Token wird verwendet, um den Load-
							; Routinen mitzuteilen, dass der Wert nicht
							; verndert werden soll

CONST	as_DisplayWidth		=	0x8014			; Die Breite wird von eI.DisplayWidth
							; bernommen

CONST	as_DisplayHeight	=	0x8015			; Wie eI.DisplayHeight

CONST	as_DisplayMax_X		=	0x8016			; Wie eI.DisplayMax_X

CONST	as_DisplayMax_Y		=	0x8017			; Wie eI.DisplayMax_Y

CONST	GP_Display_centered_X	=	0x8018			; zentriert horizontal

CONST	GP_Display_centered_Y	=	0x8019			; zentriert vertikal

CONST	GP_Display_dock_right	=	0x801A			; angedockt rechts

CONST	GP_Display_dock_bottom	=	0x801B			; angedockt unten



; enum Farb-Parameter fr Fill.LabelParameter und ColorProcessor

CONST	no_change	=	0x8013			; Dieses Token wird verwendet, um den Load-
							; Routinen mitzuteilen, dass der Wert nicht
							; verndert werden soll
							; anwendbar fr Label

CONST	autocolor	=	0x8014			; Dieses Token wird verwendet, um den Load-Routinen
							; mitzuteilen, dass fr das verwendete Register der
							; EI_FillColor-Wert in schwarz/weiss umgesetzt werden soll

CONST	as_FillColor	=	0x8015			; Dieses Token wird verwendet, um den Load-Routinen
							; mitzuteilen, dass fr das verwendete Register der gleiche
							; Wert wie EI_FillColor verwendet werden soll

CONST	as_DisplayColor =	0x8016			; Dieses Token wird verwendet, um den Load-Routinen
							; mitzuteilen, dass fr das verwendete Register der gleiche
							; Wert wie eI.DisplayColor verwendet werden soll 

CONST	darken_FillColor =	0x8017			; Dieser Wert wird verwendet, um den Load-Routinen
							; mitzuteilen, dass der abgedunkelte Farbton der Grundfarbe
							; in eI.FillColor geladen werden soll

CONST	brighten_FillColor =	0x8018			; Dieser Wert wird verwendet, um den Load-Routinen
							; mitzuteilen, dass der aufgehellte Farbton der Grundfarbe
							; in eI.FillColor geladen werden soll

	; 16.06.2007 ColorScheme ------------------------------------------------------
CONST	as_Skin_ViewTitelBackColor =	0x8019		; Dieser Wert wird verwendet, um beim ColorScheme
							; den TitelHintergrundwert zu laden

CONST	as_Skin_ViewTitelTextColor =	0x801A		; as_Skin_ViewTitelTextColor

CONST	as_Skin_ViewBodyColor =		0x801B		; as_Skin_ViewBodyColor
CONST	as_Skin_ViewBackColor =		0x801B		; as_Skin_ViewBackColor

CONST	as_Skin_FormTitelBackColor =	0x801C		; as_Skin_FormTitelBackColor

CONST	as_Skin_FormTitelTextColor =	0x801D		; as_Skin_FormTitelTextColor

CONST	as_Skin_FormBodyColor =		0x801E		; as_Skin_FormBodyColor
CONST	as_Skin_FormBackColor =		0x801E		; as_Skin_FormBackColor

CONST	as_Skin_BtnActiveBackColor =	0x801F		; as_Skin_BtnActiveBackColor

CONST	as_Skin_BtnActiveTextColor =	0x8020		; as_Skin_BtnActiveTextColor

CONST	as_Skin_BtnInActiveBackColor =	0x8021		; as_Skin_BtnInActiveBackColor

CONST	as_Skin_BtnInActiveTextColor = 	0x8022		; as_Skin_BtnInActiveTextColor

CONST	as_Skin_BtnFocusBackColor =	0x8023		; as_Skin_BtnFocusBackColor

CONST	as_Skin_BtnFocusTextColor = 	0x8024		; as_Skin_BtnFocusTextColor

CONST	as_Skin_BtnSymbolColor 	= 	0x8025		; as_Skin_BtnSymbolColor

CONST	as_Skin_BaseColor	=	0x8026		; as_Skin_BaseColor

CONST	as_Skin_Color_1		=	0x8027		; as_Skin_Color_1

CONST	as_Skin_Color_2		=	0x8028		; as_Skin_Color_2

CONST	as_Skin_BtnNavigateBackColor =	0x8029		; as_Skin_BtnNavigateBackColor

CONST	as_Skin_BtnNavigateTextColor =	0x802A		; as_Skin_BtnNavigateTextColor

CONST	as_Skin_BtnActiveDnBackColor =	0x802B		; as_Skin_BtnActiveDnBackColor

CONST	as_Skin_BtnActiveDnTextColor =	0x802C		; as_Skin_BtnActiveDnTextColor

CONST	as_Skin_ViewTextColor	=	0x802D		; as_Skin_ViewTextColor

CONST	as_Skin_FormTextColor	=	0x802E		; as_Skin_FormTextColor
	
CONST	as_Skin_EditBackColor	=	0x802F		; as_Skin_EditBackColor

CONST	as_Skin_EditTextColor	=	0x8030		; as_Skin_EditTextColor

CONST	as_Skin_EditMarkBackColor =	0x8031		; as_Skin_EditMarkBackColor

CONST	as_Skin_EditCursorColor	=	0x8032		; as_Skin_EditCursorColor

CONST	as_Skin_EditMarkTextColor =	0x8033  	; as_Skin_EditMarkTextColor

CONST	as_BackgroundColor	= 	0x8034		; as_BackgroundColor



; 21.06.2008 ColorPalette -----------------------------------------------------
CONST	as_Palette_Color_1	=	0x8100		; dunkelste Farbe
CONST	as_Palette_Color_2	=	0x8101		; zweitdunkelste Farbe
CONST	as_Palette_Color_3	=	0x8102		; drittdunkelste Farbe
CONST	as_Palette_Color_4	=	0x8103		; viertdunkelste Farbe
CONST	as_Palette_Color_5	=	0x8104		; OriginalFarbe
CONST	as_Palette_Color_6	=	0x8105		; vierthellste Farbe
CONST	as_Palette_Color_7	=	0x8106		; dritthellste Farbe
CONST	as_Palette_Color_8	=	0x8107		; zweithellste Farbe
CONST	as_Palette_Color_9	=	0x8108		; hellste Farbe
CONST	as_Palette_Color_AC	=	0x8109		; Kontrastfarbe zur Palette
CONST	as_Palette_Color_BW	=	0x810A		; zu schwarz/weiss umgesetze Farbe
CONST	as_Palette_Color_RG	=	0x810B		; red-green swap zu Original Farbe
CONST	as_Palette_Color_GB	=	0x810C		; green-blue swap zu Original Farbe
CONST	as_Palette_Color_BR	=	0x810D		; blue-red swap zu Original Farbe
CONST	as_Palette_Color_INV	=	0x810E		; inverse zu Original Farbe


; 21.06.2008 PaletteGrey ------------------------------------------------------
; zu den Farben gibt es die entsprechenden Grautne
CONST	as_Palette_Grey_1	=	0x8110		; dunkelster Grauwert
CONST	as_Palette_Grey_2	=	0x8111		; zweitdunkelster Grauwert
CONST	as_Palette_Grey_3	=	0x8112		; drittdunkelste Grauwert
CONST	as_Palette_Grey_4	=	0x8113		; viertdunkelste Grauwert
CONST	as_Palette_Grey_5	=	0x8114		; Grauwert zur OriginalFarbe
CONST	as_Palette_Grey_6	=	0x8115		; vierthellster Grauwert
CONST	as_Palette_Grey_7	=	0x8116		; dritthellster Grauwert
CONST	as_Palette_Grey_8	=	0x8117		; zweithellster Grauwert
CONST	as_Palette_Grey_9	=	0x8118		; hellster Grauwert
CONST	as_Palette_Grey_AC	=	0x8119		; Kontrastfarbe zur Palette
CONST	as_Palette_Grey_BW	=	0x811A		; zu schwarz/weiss umgesetze Farbe
CONST	as_Palette_Grey_RG	=	0x811B		; red-green swap zu Grauwert
CONST	as_Palette_Grey_GB	=	0x811C		; green-blue swap zu Grauwert
CONST	as_Palette_Grey_BR	=	0x811D		; blue-red swap zu Grauwert
CONST	as_Palette_Grey_INV	=	0x811E		; inverse zu Grauwert


; 29.06.2008 ColorPalette_Color75 ---------------------------------------------
; 75% der Palettenfarbe 25% der Mixfarbe

CONST	as_Palette_Color75_1	=	0x8120		; dunkelste Farbe 75%
CONST	as_Palette_Color75_2	=	0x8121		; zweitdunkelste Farbe 75%
CONST	as_Palette_Color75_3	=	0x8122		; drittdunkelste Farbe 75%
CONST	as_Palette_Color75_4	=	0x8123		; viertdunkelste Farbe 75%
CONST	as_Palette_Color75_5	=	0x8124		; OriginalFarbe 75%
CONST	as_Palette_Color75_6	=	0x8125		; vierthellste Farbe 75%
CONST	as_Palette_Color75_7	=	0x8126		; dritthellste Farbe 75%
CONST	as_Palette_Color75_8	=	0x8127		; zweithellste Farbe 75%
CONST	as_Palette_Color75_9	=	0x8128		; hellste Farbe 75%
CONST	as_Palette_Color75_AC	=	0x8129		; Kontrastfarbe zur Palette
CONST	as_Palette_Color75_BW	=	0x812A		; zu schwarz/weiss umgesetze Farbe
CONST	as_Palette_Color75_RG	=	0x812B		; red-green swap zu Farbe 75%
CONST	as_Palette_Color75_GB	=	0x812C		; green-blue swap zu Farbe 75%
CONST	as_Palette_Color75_BR	=	0x812D		; blue-red swap zu Farbe 75%
CONST	as_Palette_Color75_INV	=	0x812E		; inverse zu Farbe 75%


; 29.06.2008 ColorPalette_Color50 ---------------------------------------------
; 50% der Palettenfarbe 50% der Mixfarbe

CONST	as_Palette_Color50_1	=	0x8130		; dunkelste Farbe 50%
CONST	as_Palette_Color50_2	=	0x8131		; zweitdunkelste Farbe 50%
CONST	as_Palette_Color50_3	=	0x8132		; drittdunkelste Farbe 50%
CONST	as_Palette_Color50_4	=	0x8133		; viertdunkelste Farbe 50%
CONST	as_Palette_Color50_5	=	0x8134		; OriginalFarbe 50%
CONST	as_Palette_Color50_6	=	0x8135		; vierthellste Farbe 50%
CONST	as_Palette_Color50_7	=	0x8136		; dritthellste Farbe 50%
CONST	as_Palette_Color50_8	=	0x8137		; zweithellste Farbe 50%
CONST	as_Palette_Color50_9	=	0x8138		; hellste Farbe 50%
CONST	as_Palette_Color50_AC	=	0x8139		; Kontrastfarbe zur Palette
CONST	as_Palette_Color50_BW	=	0x813A		; zu schwarz/weiss umgesetze Farbe
CONST	as_Palette_Color50_RG	=	0x813B		; red-green swap zu Farbe 50%
CONST	as_Palette_Color50_GB	=	0x813C		; green-blue swap zu Farbe 50%
CONST	as_Palette_Color50_BR	=	0x813D		; blue-red swap zu Farbe 50%
CONST	as_Palette_Color50_INV	=	0x813E		; inverse zu Farbe 50%


; 29.06.2008 ColorPalette_Color25 ---------------------------------------------
; 25% der Palettenfarbe 75% der Mixfarbe

CONST	as_Palette_Color25_1	=	0x8140		; dunkelste Farbe 25%
CONST	as_Palette_Color25_2	=	0x8141		; zweitdunkelste Farbe 25%
CONST	as_Palette_Color25_3	=	0x8142		; drittdunkelste Farbe 25%
CONST	as_Palette_Color25_4	=	0x8143		; viertdunkelste Farbe 25%
CONST	as_Palette_Color25_5	=	0x8144		; OriginalFarbe 25%
CONST	as_Palette_Color25_6	=	0x8145		; vierthellste Farbe 25%
CONST	as_Palette_Color25_7	=	0x8146		; dritthellste Farbe 25%
CONST	as_Palette_Color25_8	=	0x8147		; zweithellste Farbe 25%
CONST	as_Palette_Color25_9	=	0x8148		; hellste Farbe 25%
CONST	as_Palette_Color25_AC	=	0x8149		; Kontrastfarbe zur Palette
CONST	as_Palette_Color25_BW	=	0x814A		; zu schwarz/weiss umgesetze Farbe
CONST	as_Palette_Color25_RG	=	0x814B		; red-green swap zu Farbe 25%
CONST	as_Palette_Color25_GB	=	0x814C		; green-blue swap zu Farbe 25%
CONST	as_Palette_Color25_BR	=	0x814D		; blue-red swap zu Farbe 25%
CONST	as_Palette_Color25_INV	=	0x814E		; inverse zu Farbe 25%




	; 23.06.2008 ShowEffects fr die Methode Display.ShowWindowEffect ------------
CONST	ShowWindowEffect_Quick		= 0		; Ohne Effekt, sofort
CONST	ShowWindowEffect_ToCenter	= 1		; Vom Rand ins Zentrum
CONST	ShowWindowEffect_TopDown	= 2		; von oben nach unten
CONST	ShowWindowEffect_BottomUp	= 3		; von unten nach oben
CONST	ShowWindowEffect_LeftRight	= 4		; von links nach rechts
CONST	ShowWindowEffect_RightLeft	= 5		; von rechts nach links
CONST	ShowWindowEffect_ToLowerLeft	= 6		; in untere linke Ecke
CONST	ShowWindowEffect_ToLowerRight	= 7		; in untere rechte Ecke
CONST	ShowWindowEffect_ToUpperLeft	= 8		; in obere linke Ecke
CONST	ShowWindowEffect_ToUpperRight	= 9		; in obere rechte Ecke



	; 14.06.2008 ColorScheme -----------------------------------------------------
CONST	ColorScheme_Classic	=	0x8001		; Klassisches ColorScheme



; enum ErrorCodes ----------------------------------------------------------------------
; mgliche Werte des Registers EI_ErrorCode, EIFOX_ErrorCode

CONST	NoError				=	0	; kein Fehler
CONST	FileNotFound			=	1	; File nicht gefunden
CONST	CFC_Missing			=	2	; Compact Flash Card fehlt
CONST	EGI_Corrupt			=	3	; Defektes EGI
CONST	eVM_General_Error		=	256	; eVM genereller Fehler
CONST	eVM_EmptyString_Error		=	257	; String: leerer String
CONST	eVM_OutOfString_Error		=	258	; String: Zugriff ausserhalb String
CONST	eVM_NotInHex_Error		=	259	; String: not in Hex wo verlangt
CONST	eVM_StackOverflow		=	270	; eVM Stack Overflow
CONST	eVM_StackUnderflow		=	271	; eVM Stack Underflow


CONST	ERR_File_CFC_Missing		=	0xB8C1	; CFC missing
CONST	ERR_File_VolumeError		=	0xB8C2	; CFC present but Volume error (damaged CFC)
CONST	ERR_File_not_found		=	0xB8C3	; File not Found

CONST	ERR_String_General_Error	=	0x8480	; Strings: Genereller Fehler
CONST	ERR_String_Out_Of_String	=	0x8481	; Position ausserhalb des Strings
CONST	ERR_String_NoSpaceInString	=	0x8482	; kein Platz im String
CONST	WAR_String_EmptyString		=	0x2483	; leerer String
CONST	WAR_String_NotEnoughSpace	=	0x2484	; nicht gengend Platz im ZielString, Funktion unvollstndig
CONST	ERR_String_NotInHex		=	0x8485	; kein HEX-Zeichen, wo verlangt
CONST	ERR_String_Line_Out_Of_String	=	0x8486	; angeforderte Linie zu gross

CONST	ERR_Math_OutOfRange		=	0x84C5	; Math out of Range error: Wertebereich nicht richtig



; ASCII-Characters ----------------------------------------------------------------------
CONST	NUL		=	0		; ASCII NUL als Stringabschluss
CONST	TAB		=	9		; ASCII TAB  Tabulator-Taste
CONST	LF		=	10		; ASCII LF  LineFeed
CONST	CR		=	13		; ASCII CR  Carriage Return, Enter-Taste
CONST	ESC		=	27		; ASCII ESC Escape
CONST	BACKSLASH	=	0x5C		; ASCII Backslash
CONST	NIL		=	0xFFFF		; NilPointer


; enum AD-Kanle  -----------------------------------------------------------------------
; die Ausgnge sind auf den Expansion Connector CN12 gefhrt (FOXS)


CONST	AD_CH0		=	0		; Analog Channel 0
CONST	AD_CH1		=	1		; Analog Channel 1
CONST	AD_CH2		=	2		; Analog Channel 2
CONST	AD_CH3		=	3		; Analog Channel 3
CONST	AD_CH4		=	4		; Analog Channel 4
CONST	AD_CH5		=	5		; Analog Channel 5
CONST	AD_CH6		=	6		; Analog Channel 6
CONST	AD_CH7		=	7		; Analog Channel 7


; enum Port Definitionen  -----------------------------------------------------
; die Ausgnge sind auf den Expansion Connector CN12 gefhrt (FOXS)


CONST	OP72		=	72		; Output Port P72	 (PWM fr Backlight)
CONST	OP90		=	90		; Output Port P90
;CONST	OP91		=	91		; Output Port P91	; nderung am 13.6.2007
;CONST	IP92		=	92		; Input  Port P92	; nderung am 13.6.2007
CONST	IP91		=	91		; Input  Port P91	; nderung am 13.6.2007	
CONST	OP92		=	92		; Output Port P92	; nderung am 13.6.2007
CONST	OP93		=	93		; Output Port P93	; 15.01.2009 DA-Output
CONST	OP94		=	94		; Output Port P94	; 11.01.2009 DA-Output

; ab 19.10.2009 zu verwenden --------------------------------------------------
CONST	Input_IP91	=	91		; Input  Port P91	; 19.10.2009 Counter Input
CONST	Output_OP76	=	76		; Output Port P91	; 19.10.2009 PWM-Output
CONST	Output_OP90	=	90		; Output Port P90	; 19.10.2009 Output
CONST	Output_OP93	=	93		; Output Port P93	; 19.10.2009 DA-Output
CONST	Output_OP94	=	94		; Output Port P94	; 19.10.2009 DA-Output




; enum Digital Output Driver Functions ----------------------------------------
; steuert die Ausgangsfunktion


CONST	Output_Off	=	0		; Output aus
CONST	Output_On	=	1		; Output ein
CONST	Output_Pulse	=	2		; Pulse Funktion
CONST	Output_Toggle	=	3		; wechselt den Ausgang
CONST	Output_Clock	=	5		; Ausgangstakt
CONST	Output_PulseTouchDown	=	6	; bei einem Touch Down wird ein Puls ausgegeben



; enum Symbols -------------------------------------------------------------------------
; Symbole aus Symbol-Library


CONST	Symbol32A_Space		=	0x8020	; Symbol32A Space
CONST	Symbol32A_Exclamation	=	0x8021	; Symbol32A Ausrufezeichen
CONST	Symbol32A_Plus		=	0x802B	; Symbol32A Plus
CONST	Symbol32A_Minus		=	0x802D	; Symbol32A Minus
CONST	Symbol32A_DecimalPoint	=	0x802E	; Symbol32A Dezimalpunkt

CONST	Symbol32A_Zero		=	0x8030	; Symbol32A Null
CONST	Symbol32A_One		=	0x8031	; Symbol32A Eins
CONST	Symbol32A_Two		=	0x8032	; Symbol32A Zwei
CONST	Symbol32A_Three		=	0x8033	; Symbol32A Drei
CONST	Symbol32A_Four		=	0x8034	; Symbol32A Vier
CONST	Symbol32A_Five		=	0x8035	; Symbol32A Fnf
CONST	Symbol32A_Six		=	0x8036	; Symbol32A Sechs
CONST	Symbol32A_Seven		=	0x8037	; Symbol32A Sieben
CONST	Symbol32A_Eight		=	0x8038	; Symbol32A Acht
CONST	Symbol32A_Nine		=	0x8039	; Symbol32A Neun

CONST	Symbol32A_Arrow_down	=	0x803A	; Symbol32A Pfeil abwrts
CONST	Symbol32A_Arrow_up	=	0x803B	; Symbol32A Pfeil aufwrts
CONST	Symbol32A_Arrow_left	=	0x803C	; Symbol32A Pfeil links
CONST	Symbol32A_Arrow_right	=	0x803E	; Symbol32A Pfeil rechts

CONST	Symbol32A_Equal		=	0x803D	; Symbol32A Gleichheitszeichen
CONST	Symbol32A_Question	=	0x803F	; Symbol32A Fragezeichen

CONST	Symbol32A_Multiply	=	0x802A	; Symbol32A Multiplikationszeichen
CONST	Symbol32A_Add		=	0x802B	; Symbol32A Addition
CONST	Symbol32A_More		=	0x802C	; Symbol32A Punkte fr mehr
CONST	Symbol32A_Subtract	=	0x802D	; Symbol32A Subtraktion
CONST	Symbol32A_DecimalDot	=	0x802E	; Symbol32A Dezimalpunkt
CONST	Symbol32A_Division	=	0x802F	; Symbol32A Division

CONST	Symbol32A_OK		=	0x8040	; Symbol32A OK
CONST	Symbol32A_NotOK		=	0x8041	; Symbol32A NotOK
CONST	Symbol32A_Checked	=	0x8042	; Symbol32A Checked
CONST	Symbol32A_Border1	=	0x8043	; Symbol32A Border1
CONST	Symbol32A_Border2	=	0x8044	; Symbol32A Border2
CONST	Symbol32A_Border3	=	0x8045	; Symbol32A Border3
CONST	Symbol32A_Full		=	0x8046	; Symbol32A Full
CONST	Symbol32A_Star8		=	0x8047	; Symbol32A Star8
CONST	Symbol32A_Heart		=	0x8048	; Symbol32A Heart
CONST	Symbol32A_BigDot		=	0x8049	; Symbol32A BigDot
CONST	Symbol32A_Border2RoundCorner 	=	0x804A	; Symbol32A Border2 gerundete Ecken
CONST	Symbol32A_FullRoundCorner	=	0x804B	; Symbol32A Full gerundete Ecken
CONST	Symbol32A_Checker1	=	0x804C	; Symbol32A Schachbrettmuster 1 Pixel gross
CONST	Symbol32A_H_Line1	=	0x804D	; Symbol32A horizontale Linien
CONST	Symbol32A_H_Grid_2	=	0x804E	; Symbol32A Liniennetz 1
CONST	Symbol32A_H_Grid_4	=	0x804F	; Symbol32A Liniennetz 4
CONST	Symbol32A_Exit_1	=	0x8061	; Symbol32A Exit
CONST	Symbol32A_Home_1	=	0x8062	; Symbol32A Home
CONST	Symbol32A_Enter_1	=	0x8063	; Symbol32A Enter
CONST	Symbol32A_Space_1	=	0x8064	; Symbol32A Space
CONST	Symbol32A_Locked_1	=	0x8065	; Symbol32A Locked
CONST	Symbol32A_Unlocked_1	=	0x8066	; Symbol32A Unlocked
CONST	Symbol32A_Level_hor_1	=	0x8067	; Symbol32A Pegelanzeige horizontal
CONST	Symbol32A_Level_vert_1	=	0x8068	; Symbol32A Pegelanzeige vertikal
CONST	Symbol32A_Slider_V1_A	=	0x8069	; Symbol32A Slider vertikal Typ 1 3D Body
CONST	Symbol32A_Slider_V1_B	=	0x806A	; Symbol32A Slider vertikal Typ 1 3D Fill 1
CONST	Symbol32A_Slider_V1_C	=	0x806B	; Symbol32A Slider vertikal Typ 1 3D Fill 2
CONST	Symbol32A_123			=	0x806C	; Symbo32A 123... Symbol
CONST	Symbol32A_ABC			=	0x806D	; Symbo32A ABC... Symbol
CONST	Symbol32A_Hatch_up_1		=	0x806E	; Symbo32A Schraffur nach oben
CONST	Symbol32A_Hatch_down_1	=	0x806F	; Symbo32A Schraffur nach unten
CONST	Symbol32A_Hatch_up_2		=	0x8070	; Symbo32A Schraffur 4 nach oben
CONST	Symbol32A_Hatch_down_2	=	0x8071	; Symbo32A Schraffur 4 nach unten

CONST	Symbol32A_MIN_1		=	0x8072	; Symbo32A Minimumzeichen
CONST	Symbol32A_MAX_1		=	0x8073	; Symbo32A Maximumzeichen
CONST	Symbol32A_DEF_1		=	0x8074	; Symbo32A Defaultzeichen


CONST	Symbol32A_ToStart	=	0x8076	; Symbol32 Start
CONST	Symbol32A_ToEnd		=	0x8077	; Symbol32 End
CONST	Symbol32A_Pause		=	0x8078	; Symbol32 Pause

CONST	Symbol32A_Watch		=	0x8079	; Symbol32 Uhr
CONST	Symbol32A_Power		=	0x807A	; Symbol32 Power
CONST	Symbol32A_Calendar	=	0x807B	; Symbol32 Kalender
CONST	Symbol32A_Cursor_Left	=	0x807C	; Symbol32 Cursor links
CONST	Symbol32A_Cursor_Right	=	0x807D	; Symbol32 Cursor rechts
CONST	Symbol32A_Cursor_Up	=	0x807E	; Symbol32 Cursor auf
CONST	Symbol32A_Cursor_Down	=	0x807F	; Symbol32 Cursor ab
CONST	Symbol32A_Coins		=	0x8080	; Symbol32 Geldstcke (bezahlen)
CONST	Symbol32A_KBD_ESC	=	0x8081	; Symbol32 Keyboardtaste ESC
CONST	Symbol32A_KBD_SHIFT	=	0x8082	; Symbol32 Keyboardtaste SHIFT
CONST	Symbol32A_KBD_TAB	=	0x8083	; Symbol32 Keyboardtaste TAB
CONST	Symbol32A_KBD_HOME	=	0x8084	; Symbol32 Keyboardtaste HOME
CONST	Symbol32A_KBD_END	=	0x8085	; Symbol32 Keyboardtaste END
CONST	Symbol32A_KBD_BackSpace	=	0x8086	; Symbol32 Keyboardtaste BackSpace
CONST	Symbol32A_KBD_PageDown	=	0x8087	; Symbol32 Keyboardtaste PageDown
CONST	Symbol32A_KBD_PageUp	=	0x8088	; Symbol32 Keyboardtaste PageUp
CONST	Symbol32A_KBD_CAPS	=	0x8089	; Symbol32 Keyboardtaste CAPS
CONST	Symbol32A_KBD_CTRL	=	0x808A	; Symbol32 Keyboardtaste CTRL
CONST	Symbol32A_KBD_ALT	=	0x808B	; Symbol32 Keyboardtaste ALT
CONST	Symbol32A_KBD_ALTGR	=	0x808C	; Symbol32 Keyboardtaste ALTGR
CONST	Symbol32A_KBD_DEL	=	0x808D	; Symbol32 Keyboardtaste DEL
CONST	Symbol32A_KBD_INS	=	0x808E	; Symbol32 Keyboardtaste INS
CONST	Symbol32A_KBD_ENTER	=	0x808F	; Symbol32 Keyboardtaste ENTER
CONST	Symbol32A_PreviousPage	=	0x8090	; Symbol32 Keyboardtaste Seite zurckblttern
CONST	Symbol32A_NextPage	=	0x8091	; Symbol32 Keyboardtaste Seite vorwrtsblttern
CONST	Symbol32A_Close		=	0x8092	; Symbol32 Schliessen
CONST	Symbol32A_Stop		=	0x8093	; Symbol32 Stop
CONST	Symbol32A_Smile_Happy	=	0x8094	; Symbol32 Smile_Happy
CONST	Symbol32A_Smile_Stroke	=	0x8095	; Symbol32 Smile_Stroke
CONST	Symbol32A_Smile_Sad	=	0x8096	; Symbol32 Smile_Sad
CONST	Symbol32A_Repeat	=	0x8097	; Symbol32 Repeat
CONST	Symbol32A_Info		=	0x8098	; Symbol32 Info
CONST	Symbol32A_Arrow_left_2	=	0x8099	; Symbol32A Pfeil links,    nicht ausgefllt
CONST	Symbol32A_Arrow_right_2	=	0x809A	; Symbol32A Pfeil rechts,   nicht ausgefllt
CONST	Symbol32A_Arrow_down_2	=	0x809B	; Symbol32A Pfeil abwrts,  nicht ausgefllt
CONST	Symbol32A_Arrow_up_2	=	0x809C	; Symbol32A Pfeil aufwrts, nicht ausgefllt
CONST	Symbol32A_Battery_Full	=	0x809D	; Symbol32A Batterie voll
CONST	Symbol32A_Battery_LoBat =	0x809E	; Symbol32A Batterie leer
CONST	Symbol32A_Battery_Check	=	0x809F	; Symbol32A Batterie prfen
CONST	Symbol32A_Power_Connected =	0x80A0	; Symbol32A Netz angeschlossen
CONST	Symbol32A_Power_NotConnected =	0x80A1	; Symbol32A Netz nicht angeschlossen
CONST	Symbol32A_SwissFlag	 =	0x80A2	; Symbol32A Schweizerflagge
CONST	Symbol32A_Arrow_Exchange =	0x80A3	; Symbol32A Exchange Pfeile
CONST	Symbol32A_Arrow_LeftRight =	0x80A4	; Symbol32A LeftRight Pfeile
CONST	Symbol32A_Arrow_UpDown =	0x80A5	; Symbol32A UpDown Pfeile
CONST	Symbol32A_File_Write	 =	0x80A6	; Symbol32A File Write
CONST	Symbol32A_File_Read	 =	0x80A7	; Symbol32A File Read
CONST	Symbol32A_Schematic	 =	0x80A8	; Symbol32A File Write
CONST	Symbol32A_Layout	 =	0x80A9	; Symbol32A File Read
CONST	Symbol32A_Arrow_left_3	=	0x80AA	; Symbol32A Pfeil links,    kleiner
CONST	Symbol32A_Arrow_right_3	=	0x80AB	; Symbol32A Pfeil rechts,   kleiner
CONST	Symbol32A_Arrow_down_3	=	0x80AC	; Symbol32A Pfeil abwrts,  kleiner
CONST	Symbol32A_Arrow_up_3	=	0x80AD	; Symbol32A Pfeil aufwrts, kleiner

; enum SerialInterface ---------------------------------------------------------------------

CONST	 COM0 = 0				; Serielle Schnittstelle UART0
CONST	 COM1 = 1				; Serielle Schnittstelle UART1
CONST	 COM2 = 2				; Serielle Schnittstelle UART2

; enum Display WriteModes -------------------------------------------------------------------

; Werte die in das Register eI.Display_WriteMode geladen werden knnen

CONST	 Write_To_RVR	 = 01		; Schreiben ins Refresh Video RAM
CONST	 Write_To_AVR	 = 02		; Schreiben ins Accessible Video RAM
CONST	 Write_To_AVR_RVR = 03		; Schreiben ins Accessible und ins Refresh Video RAM (default)



; Mathematische Konstanten -------------------------------------------------------------------

CONST		PI = 3.1415926535897932384626433832795
CONST		e = 2.718281828



; enum Serial communication Baudrates --------------------------------------------------------

CONST	Baud_9600	=	0	;       9'600 Baud
CONST	Baud_19200	=	1	;      19'200 Baud
CONST	Baud_38400	=	2	;      38'400 Baud
CONST	Baud_57600	=	3	;      57'600 Baud
CONST	Baud_115200	=	4	;     115'200 Baud
CONST	Baud_250000	=	5	;     250'000 Baud
CONST	Baud_2400	=	6	;       2'400 Baud
CONST	Baud_4800	=	7	;       4'800 Baud
CONST	Baud_1200	=	8	;       1'200 Baud


; enum ZeitFormate ---------------------------------------------------------------------------

CONST	FormatTime_XX_XX_XX		=	0	; Beispiel ??:??:???? mit FillChar = ?
CONST	FormatTime_HH_MM_SS		=	1	; Beispiel 21:45:36
CONST	FormatTime_HH_MM_SS_XXX		=	2	; Beispiel 21:45:06.230
CONST	FormatTime_HH_MM		=	3	; Beispiel 08:05

; enum DatumsFormate -------------------------------------------------------------------------

CONST	FormatDate_XX.XX.XXXX			=	0	; Beispiel ??.??.???? mit FillChar = ?
CONST	FormatDate_DD.MM.YYYY			=	1	; Beispiel 12.08.2007
CONST	FormatDate_DD.MM.YY			=	2	; Beispiel 12.08.07
CONST	FormatDate_YYMMDD			=	3	; Beispiel 070812
CONST	FormatDate_ISO8601_YYYYMMDD		=	4	; Beispiel 20070812
CONST	FormatDate_ISO8601_YYYY_MM_DD 		=	5	; Beispiel 2007-08-12


; enum ChecksumFormate -------------------------------------------------------------------------

CONST	ChecksumFunction_ADD			=	1	; Checksumme durch ADD
CONST	ChecksumFunction_XOR			=	2	; Checksumme durch XOR
CONST	ChecksumFunction_CCITT16		=	3	; Checksumme durch CCITT16

; enum ProcessImage Werte fr eI.EGI_ProcessImage ----------------------------------------------
CONST	ProcessImage_normal			=	0	; Bild nicht bearbeiten
CONST	ProcessImage_grey			=	1	; Bild in Graustufen
CONST	ProcessImage_negative			=	2	; Bild invertieren
CONST	ProcessImage_getEGIsize			=	3	; Bildgrsse holen
CONST	ProcessImage_last			=	3	; Endmarke


; enum RoundCorner Werte fr Draw.FillRectangleSoft -----------------------------------------------

; Ecke      D-----A
; 	                   
; Ecke      C-----B


CONST	RoundCorner_all				= 	0	; alle Ecken gerundet
CONST	RoundCorner_BCD				=	1	
CONST	RoundCorner_ACD				=	2	
CONST	RoundCorner_CD				=	3	
CONST	RoundCorner_ABD				=	4	
CONST	RoundCorner_BD				=	5	
CONST	RoundCorner_AD				=	6	
CONST	RoundCorner_D				=	7	

CONST	RoundCorner_ABC				= 	8	
CONST	RoundCorner_BC				=	9	
CONST	RoundCorner_AC				=	10	
CONST	RoundCorner_C				=	11	
CONST	RoundCorner_AB				=	12	
CONST	RoundCorner_B				=	13	
CONST	RoundCorner_A				=	14	
CONST	RoundCorner_none			=	15	; alle Ecken eckig



; enum Sound_DA ---------------------------------------------------------------

CONST	Sound_Mode_IDLE				= 0
CONST	Sound_Mode_STOP				= 1
CONST	Sound_Mode_PLAY_STEREO			= 2	; Stereo OP93 und OP94
CONST	Sound_Mode_PLAY_MONO			= 3	; Mono   OP93 und OP94
CONST	Sound_Mode_PLAY_L			= 4	; Mono   OP93
CONST	Sound_Mode_PLAY_R			= 5	; Mono   OP94
CONST	Sound_Mode_REWIND			= 6	; Rewind
CONST	Sound_Mode_PAUSE			= 7	; Pause
CONST	Sound_Mode_CHAIN			= 8	; Sounds/Buffer verknpfen




; enum HardwareCode Werte fr eI.HardwareCode ---------------------------------
CONST	HardwareCode_FOXS		= 0x0100	; FOXS-Family
CONST	HardwareCode_FOXS_V0540		= 0x0101	; FOXS_V0540
CONST	HardwareCode_FOXS_V0735		= 0x0102	; FOXS_V0735

CONST	HardwareCode_FOXR		= 0x0200	; FOXR-Family
CONST	HardwareCode_FOXR_V0809		= 0x0201	; FOXR_V0809
CONST	HardwareCode_FOXR_V0940		= 0x0202	; FOXR_V0940


CONST	HardwareCode_FOX57		= 0x0300	; FOX57-Family
CONST	HardwareCode_FOX57_V0722	= 0x0301	; FOX57_V0722
CONST	HardwareCode_FOX57_V0910	= 0x0302	; FOX57_V0910

CONST	HardwareCode_FOX70		= 0x0400	; FOX70-Family
CONST	HardwareCode_FOX70_V0828	= 0x0401	; FOX70_V0828
CONST	HardwareCode_FOX70_V0921	= 0x0402	; FOX70_V0921

CONST	HardwareCode_F57C		= 0x0500	; F57C-Family
CONST	HardwareCode_F57C_V0938		= 0x0501	; F57C_V0938


; enum Werte im eI.HS_EventType Register --------------------------------------
CONST	HS_EVENT_NONE 			= 0		; no event
CONST	HS_EVENT_ENTER			= 1		; Enter event
CONST	HS_EVENT_LEAVE			= 2		; Leave event
CONST	HS_EVENT_DOWN			= 3		; Down event
CONST	HS_EVENT_UP			= 4		; Up event

; enum I2C Constants ----------------------------------------------------------

CONST	I2C_DATADIRECTION_WRITE		= 0		; I2C-Bus Datadirection
CONST	I2C_DATADIRECTION_READ		= 1		; I2C-Bus Datadirection

CONST	I2C_MODE_STANDARD		= 1		; I2C Standard-Mode



